% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stergm.R
\name{stergm}
\alias{stergm}
\title{Separable Temporal Exponential Family Random Graph Models}
\usage{
stergm(
  nw,
  formation,
  dissolution,
  constraints = ~.,
  estimate,
  times = NULL,
  offset.coef.form = NULL,
  offset.coef.diss = NULL,
  targets = NULL,
  target.stats = NULL,
  eval.loglik = NVL(getOption("tergm.eval.loglik"), getOption("ergm.eval.loglik")),
  control = control.stergm(),
  verbose = FALSE,
  ...,
  SAN.offsets = NULL
)
}
\arguments{
\item{nw}{A \code{\link[network]{network}} object (for EGMME); or
\code{\link[networkDynamic]{networkDynamic}} object, a
\code{\link{network.list}} object, or a \code{\link{list}} containing
networks (for CMLE and CMPLE).

\code{stergm} understands the \code{\link{lasttoggle}} "API".}

\item{formation, dissolution}{One-sided \code{\link{ergm}}-style formulas for
the formation and dissolution models, respectively.  In \code{stergm},
the dissolution formula is parameterized in
terms of tie persistence: negative coefficients imply lower rates of persistence
and postive coefficients imply higher rates.  The dissolution effects are simply the
negation of these coefficients.}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being modeled, using syntax
similar to the \code{formula} argument. Multiple constraints may be given,
separated by \dQuote{+} operators.  Together with the model terms in the
formula and the reference measure, the constraints define the distribution
of networks being modeled.

The default is \code{~.}, for an unconstrained model.

See the \link[=ergm-constraints]{ERGM constraints} documentation for the
constraints implemented in the \strong{\link[=ergm-package]{ergm}} package.
Other packages may add their own constraints.

Note that not all possible combinations of constraints are supported.}

\item{estimate}{One of "EGMME" for Equilibrium Generalized Method of Moments
Estimation, based on a single network with some temporal information and
making an assumption that it is a product of a STERGM process running to its
stationary (equilibrium) distribution; "CMLE" for Conditional Maximum
Likelihood Estimation, modeling a transition between two networks, or
"CMPLE" for Conditional Maximum PseudoLikelihood Estimation, using MPLE
instead of MLE.  CMPLE is extremely inaccurate at this time.}

\item{times}{For CMLE and CMPLE estimation, times or indexes at
which the networks whose transition is to be modeled are
observed. Default to \code{c(0,1)} if \code{nw} is a
\code{\link[networkDynamic]{networkDynamic}} and to
\code{1:length(nw)} (all transitions) if \code{nw} is a
\code{\link{network.list}} or a \code{\link{list}}. Unused for
EGMME. Note that at this time, the selected time points will be
treated as temporally adjacent. Irregularly spaced time series
are not supported at this time.}

\item{offset.coef.form}{Numeric vector to specify offset formation
parameters.}

\item{offset.coef.diss}{Numeric vector to specify offset dissolution
parameters.}

\item{targets}{One-sided \code{\link{ergm}}-style formula specifying
statistics whose moments are used for the EGMME. Unused for CMLE and CMPLE.
Targets is required for EGMME estimation. It may contain any valid ergm
terms.  Any offset terms are used only during the
preliminary SAN run; they are removed automatically for the EGMME proper.
If \code{targets} is specified as a character
(one of \code{"formation"} and \code{"dissolution"}) then
the function \code{\link{.extract.fd.formulae}} is used to determine the
corresponding formula; the user should be aware of its behavior and limitations.}

\item{target.stats}{A vector specifying the values of the \code{targets}
statistics that EGMME will try to match.  Defaults to the statistics of
\code{nw}. Unused for CMLE and CMPLE.}

\item{eval.loglik}{Whether or not to calculate the log-likelihood
of a CMLE STERGM fit. See \code{\link{ergm}} for details. Can be
set globally via \code{option(tergm.eval.loglik=...)}, falling back to
\code{getOption("ergm.eval.loglik")} if not set.}

\item{control}{A list of control parameters for algorithm tuning.
Constructed using \code{\link{control.stergm}}.  Remapped to
\code{\link{control.tergm}}.}

\item{verbose}{logical or integer; if TRUE or positive, the program will
print out progress information. Higher values result in more output.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}

\item{SAN.offsets}{Offset coefficients (if any) to use during the SAN run.}
}
\value{
\code{\link{stergm}} returns an object of class \code{\link{tergm}};
see \code{\link[=tergm]{tergm()}} for details and methods.
}
\description{
\code{\link{stergm}} is used for finding Separable Temporal ERGMs' (STERGMs)
Conditional MLE (CMLE) (Krivitsky and Handcock, 2010) and Equilibrium
Generalized Method of Moments Estimator (EGMME) (Krivitsky, 2009).
}
\details{
This function is included for backwards compatibility, and users are
encouraged to use the new \code{tergm} family of functions instead.

The \code{stergm} function uses a pair of formulas, \code{formation} and
\code{dissolution} to model tie-dynamics.  The dissolution formula, however, is
parameterized in terms of tie persistence: negative coefficients imply lower
rates of persistence and postive coefficients imply higher rates.
The dissolution effects are simply the negation of these coefficients, but
the discrepancy between the terminology and interpretation has always been
unfortunate, and we have fixed this in the new \code{tergm} function.

If you are making the transition from old \code{stergm} to new \code{tergm}, note that
the \code{dissolution} formula in \code{stergm} maps to the new \code{Persist()}
operator in the \code{tergm} function, NOT the \code{Diss()} operator.

\strong{Model Terms} See \code{\link{ergm}} and \code{\link{ergm-terms}} for
details. At this time, only linear ERGM terms are allowed.  \itemize{
\item For a brief demonstration, please see the tergm package vignette:
\code{browseVignettes(package='tergm')} \item A more detailed tutorial is
available on the statnet wiki:
\url{https://statnet.org/Workshops/tergm_tutorial.html} }
}
\examples{
\dontrun{
# EGMME Example
par(ask=FALSE)
n<-30
g0<-network.initialize(n,dir=FALSE)

#                     edges, degree(1), mean.age
target.stats<-c(      n*1/2,    n*0.6,        20)

dynfit<-stergm(g0,formation = ~edges+degree(1), dissolution = ~edges,
               targets = ~edges+degree(1)+mean.age,
               target.stats=target.stats, estimate="EGMME",
               control=control.stergm(SA.plot.progress=TRUE))

par(ask=TRUE)
mcmc.diagnostics(dynfit)
summary(dynfit)
}

\donttest{
# CMLE Example
data(samplk)

# Fit a transition from Time 1 to Time 2
samplk12 <- stergm(list(samplk1, samplk2),
                   formation=~edges+mutual+transitiveties+cyclicalties,
                   dissolution=~edges+mutual+transitiveties+cyclicalties,
                   estimate="CMLE")

mcmc.diagnostics(samplk12)
summary(samplk12)

# Fit a transition from Time 1 to Time 2 and from Time 2 to Time 3 jointly
samplk123 <- stergm(list(samplk1, samplk2, samplk3),
                    formation=~edges+mutual+transitiveties+cyclicalties,
                    dissolution=~edges+mutual+transitiveties+cyclicalties,
                    estimate="CMLE")

mcmc.diagnostics(samplk123)
summary(samplk123)
}

}
\references{
Krivitsky P.N. and Handcock M.S. (2014) A Separable Model for Dynamic Networks. \emph{Journal of the Royal Statistical Society, Series B}, 76(1): 29-46. \doi{10.1111/rssb.12014}

Krivitsky, P.N. (2012). Modeling of Dynamic Networks based on
Egocentric Data with Durational Information. \emph{Pennsylvania State
University Department of Statistics Technical Report}, 2012(2012-01).
\url{https://web.archive.org/web/20170830053722/https://stat.psu.edu/research/technical-report-files/2012-technical-reports/TR1201A.pdf}
}
\seealso{
ergm, network, \\%v\\%, \\%n\\%, \code{\link{ergm-terms}}
}
