% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tergm.godfather.R
\name{tergm.godfather}
\alias{tergm.godfather}
\title{A function to apply a given series of changes to a network.}
\usage{
tergm.godfather(
  formula,
  changes = NULL,
  toggles = changes[, -4, drop = FALSE],
  start = NULL,
  end = NULL,
  end.network = FALSE,
  stats.start = FALSE,
  verbose = FALSE,
  control = control.tergm.godfather()
)
}
\arguments{
\item{formula}{An \code{\link{summary.formula}}-style formula, with
either a \code{\link{network}} or a \code{\link{networkDynamic}}
as the LHS and statistics to be computed on the RHS. If LHS is a
\code{\link{networkDynamic}}, it will be used to derive the
changes to the network whose statistics are wanted. Otherwise,
either \code{changes} or \code{toggles} must be specified, and
the LHS \code{\link{network}} will be used as the starting
network.}

\item{changes}{A matrix with four columns: time, tail, head, and
new value, describing the changes to be made. Can only be used if
LHS of \code{formula} is not a \code{\link{networkDynamic}}.}

\item{toggles}{A matrix with three columns: time, tail, and head,
giving the dyads which had changed. Can only be used if LHS of
\code{formula} is not a \code{\link{networkDynamic}}.}

\item{start}{Time from which to start applying changes.  Note that
the first set of changes will take effect at \code{start + 1}.
Defaults to the time point 1 before the earliest change passed.}

\item{end}{Time at which to finish applying changes.  Defaults to
the last time point at which a change occurs.}

\item{end.network}{Whether to return the network that
results. Defaults to \code{FALSE}.}

\item{stats.start}{Whether to return the network statistics at
\code{start} (before any changes are applied) as the first row of
the statistics matrix.  Defaults to \code{FALSE}, to produce
output similar to that of \code{\link[=simulate.tergm]{simulate}}
for TERGMs when \code{output="stats"}, where initial network's
statistics are not returned.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{control}{A control list generated by
\code{\link{control.tergm.godfather}}.}
}
\value{
If \code{end.network} is \code{FALSE} (the default), an
\code{\link{mcmc}} object with the requested network statistics
associated with the network series produced by applying the
specified changes. Its \code{\link{mcmc}} attributes encode the
timing information: so \code{\link{start}(out)} gives the time
point associated with the first row returned, and
\code{\link{end}(out)} out the last. The "thinning interval" is
always 1.

If \code{end.network} is \code{TRUE}, return a \code{\link{network}} object with
\code{\link{lasttoggle}} "extension", representing the final network, with a
matrix of statistics described in the previous paragraph attached to it as
an \code{attr}-style attribute \code{"stats"}.
}
\description{
Gives the network a series of timed proposals it can't refuse. Returns the
statistics of the network, and, optionally, the final network.
}
\seealso{
\code{\link[=simulate.tergm]{simulate.tergm()}}, \code{\link[=simulate_formula.network]{simulate_formula.network()}}, \code{\link[=simulate_formula.networkDynamic]{simulate_formula.networkDynamic()}}
}
