% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.duration.R
\name{edgecov.ages-ergmTerm}
\alias{edgecov.ages-ergmTerm}
\alias{InitErgmTerm.edgecov.ages}
\title{Weighted sum of ages of extant ties}
\usage{
# binary: edgecov.ages(x, attrname=NULL)
}
\arguments{
\item{x, attrname}{a specification for the dyadic covariate: either
one of the following, or the name of a network attribute
containing one of the following: \describe{

\item{a covariate matrix}{with dimensions \eqn{n \times n}{n*n}
for unipartite networks and \eqn{b \times (n-b)}{b*(n-b)} for
bipartite networks; \code{attrname}, if given, is used to construct
the term name.}

\item{a network object}{with the same size and bipartitedness as
LHS; \code{attrname}, if given, provides the name of the
quantitative edge attribute to use for covariate values (in
this case, missing edges in \code{x} are assigned a covariate value
of zero).}

}}
}
\description{
Weighted sum of ages of extant ties
}
\details{
This term adds one statistic equaling sum, over all ties
present in the network, of the amount of time elapsed since
formation, multiplied by a dyadic covariate.

"Weights" can be negative.

Unlike \code{\link[=edgecov.mean.age-ergmTerm]{edgecov.mean.age}} , this statistic is well-defined on
an empty network. However, if used as a target, it appears to
produce highly biased dissolution parameter estimates if the goal
is to get an intended average duration.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "edgecov.ages", "subsection")}
}
\concept{durational}
