% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk.R
\name{chk_term}
\alias{chk_term}
\title{Check Term}
\usage{
chk_term(x, validate = "class", x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{validate}{A string specifying the level of the validation.
The possible values in order of increasing strictness
are 'class', 'valid', 'consistent' and 'complete'.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
\code{NULL}, invisibly. Called for the side effect of throwing an error
if the condition is not met.
}
\description{
Checks if term using \verb{[vld_term](x)}.
}
\examples{
x <- as.term(c("x[2]", "x[1]"))
chk_term(x)
x <- c("x[2]", "x[1]")
try(chk_term(x, validate = "sorted"))
}
