% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.R
\name{dims}
\alias{dims}
\alias{dims.default}
\alias{dims.data.frame}
\title{Dimensions of an Object}
\usage{
dims(x, ...)

\method{dims}{default}(x, ...)

\method{dims}{data.frame}(x, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}
}
\value{
An integer vector of the dimensions.
}
\description{
Gets the dimensions of an object.
}
\details{
Unlike \code{base::dim()}, dims works as intuitively expected for vectors and data.frames.
A integer vector of the dimensions of a parameter can be converted
into the equivalent \code{\link[=term-vector]{term-vector()}} using \code{\link[=term]{term()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Dimensions of a default object

\item \code{data.frame}: Dimensions of a data frame
}}

\examples{
dims(character(0))
dims(1:3)
dims(data.frame())
dims(data.frame(x = 1:3))
}
\seealso{
\code{\link[base:dim]{base::dim()}}, \code{\link[=term-vector]{term-vector()}}
and \code{\link[=term]{term()}}
}
