% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kitty_colors.R
\name{kitty_colors}
\alias{kitty_colors}
\alias{kitty_background}
\alias{kitty_foreground}
\alias{kitty_palette}
\title{Get the colors used in the kitty terminal}
\usage{
kitty_colors()

kitty_background()

kitty_foreground()

kitty_palette()
}
\value{
\code{kitty_colors} returns a data.frame with the colors from the theme used
by kitty. \code{kitty_background} returns the background color (character
vector with the hex-code). \code{kitty_foreground} returns the foreground
color. \code{kitty_palette} returns a vector with the 9 main accent colors
from the theme.
}
\description{
Get the colors used in the kitty terminal
}
\details{
To get the background and foreground colors, \code{kitten query-terminal} is
called. To get all colors and the palette \code{kitty @get-colors} is called
using \code{\link{system}}. However, for the last to work
\code{allow_remote_control} needs to be set to \code{true} in the config
file for kitty.
}
\examples{
if (is_kitty()) {
  cat("The background color is '", kitty_background(), "'.")
}

}
\seealso{
\code{\link{term_background}}, \code{\link{term_foreground}},
\code{\link{term_palette}} for functions that try to return the colors used
in any terminal. When running in kitty, these will call
\code{kitty_background} etc.
}
