% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{h_tbl_median_surv}
\alias{h_tbl_median_surv}
\title{Helper Function: Survival Estimations}
\usage{
h_tbl_median_surv(fit_km, armval = "All")
}
\arguments{
\item{fit_km}{(\code{survfit})\cr result of \code{\link[survival:survfit]{survival::survfit()}}.}

\item{armval}{(\code{string})\cr used as strata name when treatment arm variable only has one level. Default is "All".}
}
\value{
A summary table with statistics \code{N}, \code{Median}, and \verb{XX\% CI} (\code{XX} taken from \code{fit_km}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Transform a survival fit to a table with groups in rows characterized by N, median and confidence interval.
}
\examples{
\donttest{
library(dplyr)
library(survival)

adtte <- tern_ex_adtte \%>\% filter(PARAMCD == "OS")
fit <- survfit(
  form = Surv(AVAL, 1 - CNSR) ~ ARMCD,
  data = adtte
)
h_tbl_median_surv(fit_km = fit)
}

}
