% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{c_label_n}
\alias{c_label_n}
\title{Content Row Function to Add Row Total to Labels}
\usage{
c_label_n(df, labelstr, .N_row)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.N_row}{(\code{integer})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is typically passed by \code{rtables}.}
}
\value{
A \code{list} containing "row_count" with the row count value and the correct label.
}
\description{
This takes the label of the latest row split level and adds the row total in parentheses.
}
\note{
It is important here to not use \code{df} but rather \code{.N_row} in the implementation, because
the former is already split by columns and will refer to the first column of the data only.
}
\keyword{internal}
