% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_rate.R
\name{incidence_rate}
\alias{incidence_rate}
\alias{s_incidence_rate}
\alias{a_incidence_rate}
\alias{estimate_incidence_rate}
\title{Incidence Rate}
\usage{
s_incidence_rate(
  df,
  .var,
  n_events,
  is_event,
  control = control_incidence_rate()
)

a_incidence_rate(
  df,
  .var,
  n_events,
  is_event,
  control = control_incidence_rate()
)

estimate_incidence_rate(
  lyt,
  vars,
  nested = TRUE,
  ...,
  show_labels = "hidden",
  table_names = vars,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{n_events}{(\code{integer})\cr number of events observed.}

\item{is_event}{(\code{logical})\cr \code{TRUE} if event, \code{FALSE} if time to event is censored.}

\item{control}{(\code{list})\cr parameters for estimation details, specified by using
the helper function \code{\link[=control_incidence_rate]{control_incidence_rate()}}. Possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level for the estimated incidence rate.
\item \code{conf_type} (\code{string})\cr \code{normal} (default), \code{normal_log}, \code{exact}, or \code{byar}
for confidence interval type.
\item \code{input_time_unit} (\code{string})\cr \code{day}, \code{week}, \code{month}, or \code{year} (default)
indicating time unit for data input.
\item \code{num_pt_year} (\code{numeric})\cr time unit for desired output (in person-years).
}}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure \emph{if
possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{s_incidence_rate()} returns the following statistics:
\itemize{
\item \code{person_years}: Total person-years at risk.
\item \code{n_events}: Total number of events observed.
\item \code{rate}: Estimated incidence rate.
\item \code{rate_ci}: Confidence interval for the incidence rate.
}
}

\itemize{
\item \code{a_incidence_rate()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{estimate_incidence_rate()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_incidence_rate()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Estimate the event rate adjusted for person-years at risk, otherwise known
as incidence rate. Primary analysis variable is the person-years at risk.
}
\section{Functions}{
\itemize{
\item \code{s_incidence_rate()}: Statistics function which estimates the incidence rate and the
associated confidence interval.

\item \code{a_incidence_rate()}: Formatted analysis function which is used as \code{afun}
in \code{estimate_incidence_rate()}.

\item \code{estimate_incidence_rate()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
library(dplyr)

df <- data.frame(
  USUBJID = as.character(seq(6)),
  CNSR = c(0, 1, 1, 0, 0, 0),
  AVAL = c(10.1, 20.4, 15.3, 20.8, 18.7, 23.4),
  ARM = factor(c("A", "A", "A", "B", "B", "B"))
) \%>\%
  mutate(is_event = CNSR == 0) \%>\%
  mutate(n_events = as.integer(is_event))

basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  estimate_incidence_rate(
    vars = "AVAL",
    n_events = "n_events",
    control = control_incidence_rate(
      input_time_unit = "month",
      num_pt_year = 100
    )
  ) \%>\%
  build_table(df)

}
\seealso{
\code{\link[=control_incidence_rate]{control_incidence_rate()}} and helper functions \link{h_incidence_rate}.
}
\keyword{internal}
