% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_biomarkers_subgroups.R
\name{response_biomarkers_subgroups}
\alias{response_biomarkers_subgroups}
\alias{tabulate_rsp_biomarkers}
\title{Tabulate biomarker effects on binary response by subgroup}
\usage{
tabulate_rsp_biomarkers(
  df,
  vars = c("n_tot", "n_rsp", "prop", "or", "ci", "pval"),
  na_str = default_na_str(),
  ...,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr containing all analysis variables, as returned by
\code{\link[=extract_rsp_biomarkers]{extract_rsp_biomarkers()}}.}

\item{vars}{(\code{character})\cr the names of statistics to be reported among:
\itemize{
\item \code{n_tot}: Total number of patients per group.
\item \code{n_rsp}: Total number of responses per group.
\item \code{prop}: Total response proportion per group.
\item \code{or}: Odds ratio.
\item \code{ci}: Confidence interval of odds ratio.
\item \code{pval}: p-value of the effect.
Note, the statistics \code{n_tot}, \code{or} and \code{ci} are required.
}}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{...}{additional arguments for the lower level functions.}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
An \code{rtables} table summarizing biomarker effects on binary response by subgroup.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The \code{\link[=tabulate_rsp_biomarkers]{tabulate_rsp_biomarkers()}} function creates a layout element to tabulate the estimated biomarker effects on a
binary response endpoint across subgroups, returning statistics including response rate and odds ratio for each
population subgroup. The table is created from \code{df}, a list of data frames returned by \code{\link[=extract_rsp_biomarkers]{extract_rsp_biomarkers()}},
with the statistics to include specified via the \code{vars} parameter.

A forest plot can be created from the resulting table using the \code{\link[=g_forest]{g_forest()}} function.
}
\details{
These functions create a layout starting from a data frame which contains
the required statistics. The tables are then typically used as input for forest plots.
}
\note{
In contrast to \code{\link[=tabulate_rsp_subgroups]{tabulate_rsp_subgroups()}} this tabulation function does
not start from an input layout \code{lyt}. This is because internally the table is
created by combining multiple subtables.
}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  mutate(rsp = AVALC == "CR")
formatters::var_labels(adrs_f) <- c(adrs_labels, "Response")

df <- extract_rsp_biomarkers(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX",
    subgroups = "BMRKR2"
  ),
  data = adrs_f
)

\donttest{
## Table with default columns.
tabulate_rsp_biomarkers(df)

## Table with a manually chosen set of columns: leave out "pval", reorder.
tab <- tabulate_rsp_biomarkers(
  df = df,
  vars = c("n_rsp", "ci", "n_tot", "prop", "or")
)

## Finally produce the forest plot.
g_forest(tab, xlim = c(0.7, 1.4))
}

}
\seealso{
\code{\link[=extract_rsp_biomarkers]{extract_rsp_biomarkers()}}
}
