% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article-tools.R
\name{convert_to_native}
\alias{convert_to_native}
\title{convert LaTeX wrapper to native pandoc AST}
\usage{
convert_to_native(article_dir, autonumber_eq = FALSE)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}

\item{autonumber_eq}{whether to autonumber the equations, default is FALSE}
}
\value{
creates a converted native AST file, as well as a pkg_meta.yaml file
}
\description{
Uses pandoc along with several lua filters
found at inst/extdata/filters in texor package
}
\details{
convert latex(wrapper) file to pandoc AST
}
\note{
pandoc (along with lua interpreter) is already installed with
 R-studio, hence if not using R-studio you will need to install pandoc.
 https://pandoc.org/installing.html

Use pandoc version greater than or equal to 3.1
}
\examples{
# Note This is a minimal example to execute this function
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
rmarkdown::pandoc_version()
texor::include_style_file(your_article_path)
rebib::aggregate_bibliography(your_article_path)
texor::convert_to_native(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
