% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,gnm-method}
\alias{extract,gnm-method}
\alias{extract.gnm}
\title{\code{\link{extract}} method for \code{gnm} objects}
\usage{
\S4method{extract}{gnm}(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.deviance = TRUE,
  include.nobs = TRUE,
  include.df = FALSE,
  include.chisq = FALSE,
  include.delta = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.deviance}{Report the deviance?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.df}{Report the degrees of freedom?}

\item{include.chisq}{Report the chi squared statistic?}

\item{include.delta}{Report the delta statistic?}

\item{...}{Custom parameters, which are handed over to subroutines. Currently
not in use.}
}
\description{
\code{\link{extract}} method for \code{gnm} objects created by the
\code{\link[gnm]{gnm}} function in the \pkg{gnm} package.
}
