% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{override}
\alias{override}
\title{Replace coefs, SEs, p-values, and/or CIs by custom values if provided}
\usage{
override(
  models,
  override.coef = 0,
  override.se = 0,
  override.pvalues = 0,
  override.ci.low = 0,
  override.ci.up = 0
)
}
\arguments{
\item{models}{A list of \linkS4class{texreg} objects (e.g., as returned by
\code{\link{get.data}}).}

\item{override.coef}{Replacement list of coefficient vectors.}

\item{override.se}{Replacement list of standard error vectors}

\item{override.pvalues}{Replacement list of p-value vectors.}

\item{override.ci.low}{Replacement list of lower-bound confidence interval
values.}

\item{override.ci.up}{Replacement list of upper-bound confidence interval
values.}
}
\value{
Same list as input list of models, but with replaced values.
}
\description{
Replace coefs, SEs, p-values, and/or CIs by custom values if provided.
}
\details{
This function replaces coefficients, standard errors, p-values, and/or
confidence intervals in a list of \linkS4class{texreg} objects. It is used by
the \code{\link{matrixreg}} and \code{\link{plotreg}} functions. The new
values must be provided as lists of equal length as the list of models, with
each element representing a vector of replacement values. If the arguments
have value \code{0}, the original values are retained. More details are found
in the documentation of the \code{\link{matrixreg}} function.
}
\seealso{
\code{\link{matrixreg}}, \code{\link{plotreg}}, \code{\link{texreg}}
}
\author{
Philip Leifeld
}
\keyword{internal}
