% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_plural.R
\name{make_plural}
\alias{make_plural}
\title{Make Plural (or Verb to Singular) Versions of Words}
\usage{
make_plural(x, keep.original = FALSE,
  irregular = lexicon::pos_df_irregular_nouns)
}
\arguments{
\item{x}{A vector of words to make plural.}

\item{keep.original}{logical.  If \code{TRUE} the original words are kept in 
the return vector.}

\item{irregular}{A \code{data.frame} of singular and plural conversions for 
irregular nouns.  The first column should be singular and the second plural 
form of the irregular noun.}
}
\value{
Returns a vector of plural words.
}
\description{
Add -s, -es, or -ies to words.
}
\examples{
x <- c('fox', 'sky', 'dog', 'church', 'fish', 'miss', 'match', 'deer', 'block')
make_plural(x)
}
\keyword{plural}
