% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_sentence_polarity.R
\name{dataset_sentence_polarity}
\alias{dataset_sentence_polarity}
\title{v1.0 sentence polarity dataset}
\source{
\url{https://www.cs.cornell.edu/people/pabo/movie-review-data/}
}
\usage{
dataset_sentence_polarity(
  dir = NULL,
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}

\item{manual_download}{Logical, set \code{TRUE} if you have manually
downloaded the file and placed it in the folder designated by running
this function with \code{return_path = TRUE}.}
}
\value{
A tibble with 10,662 rows and 2 variables:
\describe{
  \item{text}{Sentences or snippets}
  \item{sentiment}{Indicator for sentiment, "neg" for negative and "pos"
                   for positive}
}
}
\description{
5331 positive and 5331 negative processed sentences / snippets.
Introduced in Pang/Lee ACL 2005. Released July 2005.
}
\details{
Citation info:

This data was first used in Bo Pang and Lillian Lee,
``Seeing stars: Exploiting class relationships for sentiment categorization
with respect to rating scales.'', Proceedings of the ACL, 2005.

InProceedings\{pang05, \cr
author    = \{Bo Pang and Lillian Lee\}, \cr
title     = \{Seeing stars: Exploiting class relationships for sentiment \cr
              categorization with respect to rating scales\}, \cr
booktitle = \{Proceedings of the ACL\}, \cr
year      = 2005 \cr
\}
}
\examples{
\dontrun{
dataset_sentence_polarity()

# Custom directory
dataset_sentence_polarity(dir = "data/")

# Deleting dataset
dataset_sentence_polarity(delete = TRUE)

# Returning filepath of data
dataset_sentence_polarity(return_path = TRUE)
}

}
\concept{sentiment}
\keyword{datasets}
