% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textfeatures.R
\name{textfeatures}
\alias{textfeatures}
\title{textfeatures}
\usage{
textfeatures(x, sentiment = TRUE, word_dims = NULL, threads = 1,
  normalize = TRUE, export = FALSE)
}
\arguments{
\item{x}{Input data. Should be character vector or data frame with character
variable of interest named "text". If a data frame then the first "id|*_id"
variable, if found, is assumed to be an ID variable.}

\item{sentiment}{Logical, indicating whether to return sentiment analysis
features, the variables \code{sent_afinn} and \code{sent_bing}. Defaults to
FALSE. Setting this to true will speed things up a bit.}

\item{word_dims}{Integer indicating the desired number of word2vec dimension
estimates. When NULL, the default, this function will pick a reasonable
number of dimensions (ranging from 2 to 200) based on size of input. To
disable word2vec estimates, set this to 0 or FALSE.}

\item{threads}{Integer, specifying the number of threads to use when generating
word2vec estimates. Defaults to 1. Ignored if \code{word_dims = 0}.}

\item{normalize}{Logical indicating whether to normalize (mean center,
sd = 1) features. Defaults to TRUE.}

\item{export}{Logical indicating whether to store sufficient information for
exporting the feature extraction process (stores the means, standard deviations,
and the word2vec reference object, which can then be used to process new data).}
}
\value{
A tibble data frame with extracted features as columns.
}
\description{
Extracts features from text vector.
}
\examples{

## the text of five of Trump's most retweeted tweets
trump_tweets <- c(
  "#FraudNewsCNN #FNN https://t.co/WYUnHjjUjg",
  "TODAY WE MAKE AMERICA GREAT AGAIN!",
  paste("Why would Kim Jong-un insult me by calling me \\"old,\\" when I would",
    "NEVER call him \\"short and fat?\\" Oh well, I try so hard to be his",
    "friend - and maybe someday that will happen!"),
  paste("Such a beautiful and important evening! The forgotten man and woman",
    "will never be forgotten again. We will all come together as never before"),
  paste("North Korean Leader Kim Jong Un just stated that the \\"Nuclear",
    "Button is on his desk at all times.\\" Will someone from his depleted and",
    "food starved regime please inform him that I too have a Nuclear Button,",
    "but it is a much bigger &amp; more powerful one than his, and my Button",
    "works!")
)

## get the text features of a character vector
textfeatures(trump_tweets)

## data frame with a character vector named "text"
df <- data.frame(
  id = c(1, 2, 3),
  text = c("this is A!\\t sEntence https://github.com about #rstats @github",
    "and another sentence here",
    "The following list:\\n- one\\n- two\\n- three\\nOkay!?!"),
  stringsAsFactors = FALSE
)

## get text features of a data frame with "text" variable
textfeatures(df)

}
