% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTier-class.R
\docType{class}
\name{IntervalTier-class}
\alias{IntervalTier-class}
\title{IntervalTier S4 class for Praat TextGrids.}
\description{
The \code{IntervalTier} class extends the \code{\link[=Tier-class]{Tier}} class. An
\code{IntervalTier} object describes a sequence of non-overlapping labeled
intervals. An interval's label is typically the annotation of some contiguous
portion of waveform data (e.g., a phonetic segment or word in speech data).
}
\section{Slots}{

\describe{
\item{\code{name}}{A character string, the name of the Tier.}

\item{\code{number}}{An integer, the number of the Tier within the TextGrid.}

\item{\code{startTimes}}{A numeric vector, the start times of the intervals in
the IntervalTier.}

\item{\code{endTimes}}{A numeric vector, the end times of the intervals in the
IntervalTier.}

\item{\code{labels}}{A character vector, the labels of the intervals in the
IntervalTier.}
}}
\seealso{
\code{\link{IntervalTier-constructor}},
  \code{\link{IntervalTier-accessors}}, \code{\link{TextGrid-class}},
  \code{\link{Tier-class}}
}

