% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Download Documents}
\usage{
download(url, loc = tempdir(), file.out = NULL, ...)
}
\arguments{
\item{url}{The download url(s).}

\item{loc}{Where to put the files.}

\item{file.out}{Option vector of names matching \code{url}.  If this is not
given \code{\link[=download]{download()}} will try to create a name from \code{url}.}

\item{...}{Other arguments passed to \code{\link[curl:curl_download]{curl::curl_download()}}.}
}
\value{
Places a copy of the downloaded document in location specified and returns
vector of the locations as string paths.
}
\description{
This function enables downloading documents by wrapping \code{\link[curl:curl_download]{curl::curl_download()}}.
}
\examples{
\dontrun{
m <- download(
c('https://cran.r-project.org/web/packages/curl/curl.pdf',
"https://github.com/trinker/textreadr/raw/master/inst/docs/rl10075oralhistoryst002.pdf"),
)

m
}
}
