% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untokenize.R
\name{step_untokenize}
\alias{step_untokenize}
\alias{tidy.step_untokenize}
\title{Untokenization of \link{tokenlist} variables}
\usage{
step_untokenize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  sep = " ",
  skip = FALSE,
  id = rand_id("untokenize")
)

\method{tidy}{step_untokenize}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For \code{step_untokenize}, this indicates the variables to be encoded
into a \link{tokenlist}. See \code{\link[recipes:selections]{recipes::selections()}} for more
details. For the \code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is \code{NULL} until the step is trained by
\code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{sep}{a character to determine how the tokens should be separated
when pasted together. Defaults to \code{" "}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all
operations are baked when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using \code{skip = TRUE} as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_untokenize} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_untokenize} creates a \emph{specification} of a recipe step that
will convert a \link{tokenlist} into a character predictor.
}
\details{
This steps will turn a \link{tokenlist} back into a character vector. This step
is calling \code{paste} internally to put the tokens back together to a character.
}
\examples{
library(recipes)
library(modeldata)
data(okc_text)

okc_rec <- recipe(~ ., data = okc_text) \%>\%
  step_tokenize(essay0) \%>\%
  step_untokenize(essay0)

okc_obj <- okc_rec \%>\%
  prep()

juice(okc_obj, essay0) \%>\%
  slice(1:2)

juice(okc_obj) \%>\%
  slice(2) \%>\%
  pull(essay0)

tidy(okc_rec, number = 2)
tidy(okc_obj, number = 2)
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn character into tokenlist.
}
\concept{tokenlist to character steps}
