% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{step_tf}
\alias{step_tf}
\title{Term frequency of Tokens}
\usage{
step_tf(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  weight_scheme = "raw count",
  weight = 0.5,
  vocabulary = NULL,
  res = NULL,
  prefix = "tf",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("tf")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{weight_scheme}{A character determining the weighting scheme for the
term frequency calculations. Must be one of "binary", "raw count", "term
frequency", "log normalization" or "double normalization". Defaults to "raw
count".}

\item{weight}{A numeric weight used if \code{weight_scheme} is set to "double
normalization". Defaults to 0.5.}

\item{vocabulary}{A character vector of strings to be considered.}

\item{res}{The words that will be used to calculate the term frequency will
be stored here once this preprocessing step has be trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_tf} creates a \emph{specification} of a recipe step that will convert a
\code{\link[=tokenlist]{token}} variable into multiple variables containing the token
counts.
}
\details{
It is strongly advised to use \link{step_tokenfilter} before using \link{step_tf} to
limit the number of variables created, otherwise you might run into memory
issues. A good strategy is to start with a low token count and go up
according to how much RAM you want to use.

Term frequency is a weight of how many times each token appear in each
observation. There are different ways to calculate the weight and this step
can do it in a couple of ways. Setting the argument \code{weight_scheme} to
"binary" will result in a set of binary variables denoting if a token is
present in the observation. "raw count" will count the times a token is
present in the observation. "term frequency" will divide the count with the
total number of words in the document to limit the effect of the document
length as longer documents tends to have the word present more times but not
necessarily at a higher percentage. "log normalization" takes the log of 1
plus the count, adding 1 is done to avoid taking log of 0. Finally "double
normalization" is the raw frequency divided by the raw frequency of the most
occurring term in the document. This is then multiplied by \code{weight} and
\code{weight} is added to the result. This is again done to prevent a bias towards
longer documents.

The new components will have names that begin with \code{prefix}, then
the name of the variable, followed by the tokens all separated by
\code{-}. The variable names are padded with zeros. For example if
\code{prefix = "hash"}, and if \code{num_terms < 10}, their names will be
\code{hash1} - \code{hash9}. If \code{num_terms = 101}, their names will be
\code{hash001} - \code{hash101}.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected) and \code{value} (the weighting scheme).
}

\examples{
\donttest{
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_tf(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, tate_text)

tidy(tate_rec, number = 2)
tidy(tate_obj, number = 2)
}

}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}

Other Steps for Numeric Variables From Tokens: 
\code{\link{step_lda}()},
\code{\link{step_texthash}()},
\code{\link{step_tfidf}()},
\code{\link{step_word_embeddings}()}
}
\concept{Steps for Numeric Variables From Tokens}
