% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_transcript.R
\name{split_transcript}
\alias{split_transcript}
\title{Split a Transcript Style Vector on Delimiter & Coerce to Dataframe}
\usage{
split_transcript(x, delim = ":", colnames = c("person", "dialogue"),
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A transcript style vector (e.g., \code{c("greg: Who me", "sarah: yes you!")}.}

\item{delim}{The delimiter to split on.}

\item{colnames}{The column names to use for the \code{\link[data.table]{data.table}} output.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a 2 column \code{\link[data.table]{data.table}}.
}
\description{
Split a transcript style vector (e.g., \code{c("greg: Who me", "sarah: yes you!")}
into a name and dialogue vector that is coerced to a \code{\link[data.table]{data.table}}.
Leading/trailing white space in the columns is stripped out.
}
\examples{
split_transcript(c("greg: Who me", "sarah: yes you!"))

\dontrun{
## 2015 Vice-Presidential Debates Example
if (!require("pacman")) install.packages("pacman")
pacman::p_load(rvest, magrittr, xml2)

debates <- c(
    wisconsin = "110908",
    boulder = "110906",
    california = "110756",
    ohio = "110489"
)

lapply(debates, function(x){
    xml2::read_html(paste0("http://www.presidency.ucsb.edu/ws/index.php?pid=", x)) \%>\%
        rvest::html_nodes("p") \%>\%
        rvest::html_text() \%>\%
        textshape::split_index(grep("^[A-Z]+:", .)) \%>\%
        textshape::combine() \%>\%
        textshape::split_transcript() \%>\%
        textshape::split_sentence()
})
}
}

