% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{diagchk.tfm}
\alias{diagchk.tfm}
\alias{diagchk}
\alias{diagchk.um}
\title{Diagnostic checking}
\usage{
\method{diagchk}{tfm}(
  mdl,
  y = NULL,
  method = c("exact", "cond"),
  lag.max = NULL,
  lags.at = NULL,
  freq.at = NULL,
  std = TRUE,
  envir = NULL,
  ...
)

diagchk(mdl, ...)

\method{diagchk}{um}(
  mdl,
  z = NULL,
  method = c("exact", "cond"),
  lag.max = NULL,
  lags.at = NULL,
  freq.at = NULL,
  std = TRUE,
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{um}.}

\item{y}{an object of class \code{ts}.}

\item{method}{exact or conditional residuals.}

\item{lag.max}{number of lags for ACF/PACF.}

\item{lags.at}{the lags of the ACF/PACF at which tick-marks are to be drawn.}

\item{freq.at}{the frequencies of the (cum) periodogram at at which
tick-marks are to be drawn.}

\item{std}{logical. If TRUE standardized residuals are shown.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}

\item{...}{additional arguments.}

\item{z}{optional, an object of class \code{ts}.}
}
\description{
\code{diagchk} displays tools for diagnostic checking.
}
\examples{
z <- AirPassengers
airl <- um(z, i = list(1, c(1,12)), ma = list(1, c(1,12)), bc = TRUE)
diagchk(airl)
}
