% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_interleave}
\alias{dataset_interleave}
\title{Maps map_func across this dataset, and interleaves the results}
\usage{
dataset_interleave(dataset, map_func, cycle_length, block_length = 1)
}
\arguments{
\item{dataset}{A dataset}

\item{map_func}{A function mapping a nested structure of tensors (having
shapes and types defined by \code{\link[=output_shapes]{output_shapes()}} and \code{\link[=output_types]{output_types()}} to a
dataset.}

\item{cycle_length}{The number of elements from this dataset that will be
processed concurrently.}

\item{block_length}{The number of consecutive elements to produce from each
input element before cycling to another input element.}
}
\description{
Maps map_func across this dataset, and interleaves the results
}
\details{
The \code{cycle_length} and \code{block_length} arguments control the order in which
elements are produced. \code{cycle_length} controls the number of input elements
that are processed concurrently. In general, this transformation will apply
\code{map_func} to \code{cycle_length} input elements, open iterators on the returned
dataset objects, and cycle through them producing \code{block_length} consecutive
elements from each iterator, and consuming the next input element each time
it reaches the end of an iterator.
}
\examples{
\dontrun{

dataset <- tensor_slices_dataset(c(1,2,3,4,5)) \%>\%
 dataset_interleave(cycle_length = 2, block_length = 4, function(x) {
   tensors_dataset(x) \%>\%
     dataset_repeat(6)
 })

# resulting dataset (newlines indicate "block" boundaries):
c(1, 1, 1, 1,
  2, 2, 2, 2,
  1, 1,
  2, 2,
  3, 3, 3, 3,
  4, 4, 4, 4,
  3, 3,
  4, 4,
  5, 5, 5, 5,
  5, 5,
)

}

}
\seealso{
Other dataset methods: \code{\link{dataset_batch}},
  \code{\link{dataset_cache}},
  \code{\link{dataset_concatenate}},
  \code{\link{dataset_decode_delim}},
  \code{\link{dataset_filter}},
  \code{\link{dataset_map_and_batch}},
  \code{\link{dataset_map}},
  \code{\link{dataset_padded_batch}},
  \code{\link{dataset_prefetch_to_device}},
  \code{\link{dataset_prefetch}},
  \code{\link{dataset_repeat}},
  \code{\link{dataset_shuffle_and_repeat}},
  \code{\link{dataset_shuffle}},
  \code{\link{dataset_skip}}, \code{\link{dataset_take}}
}
