% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{log_event}
\alias{log_event}
\title{Log event}
\usage{
log_event(..., step = get_global_step(increment = TRUE))
}
\arguments{
\item{...}{Named values that you want to log. They can be possibly nested,
in this case, the enclosing names are considered 'run' names by TensorBoard.}

\item{step}{The step associated the logs. If \code{NULL}, a managed step counter
will be used, and the global step is increased in every call to \code{\link[=log_event]{log_event()}}.}
}
\value{
Invisibly returns the logged data.
}
\description{
Log event
}
\note{
\code{\link[=log_event]{log_event()}} writes events to the default \code{logdir}. You can query the
default \code{logdir} with \code{\link[=get_default_logdir]{get_default_logdir()}} and modify it with
\code{\link[=set_default_logdir]{set_default_logdir()}}. You can also use the \code{\link[=with_logdir]{with_logdir()}} context switcher
to temporarily modify the logdir.
}
\examples{
temp <- tempfile()
with_logdir(temp, {
  log_event(
     train = list(loss = runif(1), acc = runif(1)),
     valid = list(loss = runif(1), acc = runif(1))
  )
})
}
