% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_t_power}
\alias{vi_t_power}
\title{The T-Power Csiszar-function in log-space}
\usage{
vi_t_power(logu, t, self_normalized = FALSE, name = NULL)
}
\arguments{
\item{logu}{\code{float}-like \code{Tensor} representing \code{log(u)} from above.}

\item{t}{\code{Tensor} of same \code{dtype} as \code{logu} and broadcastable shape.}

\item{self_normalized}{\code{logical} indicating whether \verb{f'(u=1)=0}. When
\verb{f'(u=1)=0} the implied Csiszar f-Divergence remains non-negative even
when \verb{p, q} are unnormalized measures.}

\item{name}{name prefixed to Ops created by this function.}
}
\value{
t_power_of_u: \code{float}-like \code{Tensor} of the Csiszar-function
evaluated at \code{u = exp(logu)}.
}
\description{
A Csiszar-function is a member of \verb{F = \{ f:R_+ to R : f convex \}}.
}
\details{
When \code{self_normalized = True} the T-Power Csiszar-function is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{f(u) = s [ u**t - 1 - t(u - 1) ]
s = \{ -1   0 < t < 1 \}
    \{ +1   otherwise \}
}\if{html}{\out{</div>}}

When \code{self_normalized = False} the \code{- t(u - 1)} term is omitted.

This is similar to the \code{amari_alpha} Csiszar-function, with the associated
divergence being the same up to factors depending only on \code{t}.

Warning: when self_normalized = True\verb{this function makes non-log-space calculations and may therefore be numerically unstable for}|logu| >> 0`.
}
\seealso{
Other vi-functions#': 
\code{\link{vi_total_variation}()},
\code{\link{vi_triangular}()}
}
\concept{vi-functions#'}
