% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_poisson_log_normal_quadrature_compound}
\alias{tfd_poisson_log_normal_quadrature_compound}
\title{\code{PoissonLogNormalQuadratureCompound} distribution}
\usage{
tfd_poisson_log_normal_quadrature_compound(loc, scale,
  quadrature_size = 8,
  quadrature_fn = tfp$distributions$quadrature_scheme_lognormal_quantiles,
  validate_args = FALSE, allow_nan_stats = TRUE,
  name = "PoissonLogNormalQuadratureCompound")
}
\arguments{
\item{loc}{\code{float}-like (batch of) scalar \code{Tensor}; the location parameter of
the LogNormal prior.}

\item{scale}{\code{float}-like (batch of) scalar \code{Tensor}; the scale parameter of
the LogNormal prior.}

\item{quadrature_size}{\code{integer} scalar representing the number of quadrature
points.}

\item{quadrature_fn}{Function taking \code{loc}, \code{scale},
\code{quadrature_size}, \code{validate_args} and returning \code{tuple(grid, probs)}
representing the LogNormal grid and corresponding normalized weight.
Default value: \code{quadrature_scheme_lognormal_quantiles}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The \code{PoissonLogNormalQuadratureCompound} is an approximation to a
Poisson-LogNormal \href{https://en.wikipedia.org/wiki/Compound_probability_distribution}{compound distribution}, i.e.,\preformatted{p(k|loc, scale) = int_{R_+} dl LogNormal(l | loc, scale) Poisson(k | l)
approx= sum{ prob[d] Poisson(k | lambda(grid[d])) : d=0, ..., deg-1 }
}
}
\details{
By default, the \code{grid} is chosen as quantiles of the \code{LogNormal} distribution
parameterized by \code{loc}, \code{scale} and the \code{prob} vector is
\code{[1. / quadrature_size]*quadrature_size}.

In the non-approximation case, a draw from the LogNormal prior represents the
Poisson rate parameter. Unfortunately, the non-approximate distribution lacks
an analytical probability density function (pdf). Therefore the
\code{PoissonLogNormalQuadratureCompound} class implements an approximation based
on \href{https://en.wikipedia.org/wiki/Numerical_integration}{quadrature}.
Note: although the \code{PoissonLogNormalQuadratureCompound} is approximately the
Poisson-LogNormal compound distribution, it is itself a valid distribution.
Viz., it possesses a \code{sample}, \code{log_prob}, \code{mean}, \code{variance}, etc. which are
all mutually consistent.

Mathematical Details

The \code{PoissonLogNormalQuadratureCompound} approximates a Poisson-LogNormal
\href{https://en.wikipedia.org/wiki/Compound_probability_distribution}{compound distribution}.
Using variable-substitution and \href{https://en.wikipedia.org/wiki/Numerical_integration}{numerical quadrature} (default:
based on \code{LogNormal} quantiles) we can redefine the distribution to be a
parameter-less convex combination of \code{deg} different Poisson samples.
That is, defined over positive integers, this distribution is parameterized
by a (batch of) \code{loc} and \code{scale} scalars.

The probability density function (pdf) is,\preformatted{pdf(k | loc, scale, deg) = sum{ prob[d] Poisson(k | lambda=exp(grid[d])) : d=0, ..., deg-1 }
}

Note: \code{probs} returned by (optional) \code{quadrature_fn} are presumed to be
either a length-\code{quadrature_size} vector or a batch of vectors in 1-to-1
correspondence with the returned \code{grid}. (I.e., broadcasting is only partially supported.)
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: \code{\link{tfd_autoregressive}},
  \code{\link{tfd_batch_reshape}},
  \code{\link{tfd_bernoulli}}, \code{\link{tfd_beta}},
  \code{\link{tfd_binomial}},
  \code{\link{tfd_categorical}}, \code{\link{tfd_cauchy}},
  \code{\link{tfd_chi2}}, \code{\link{tfd_chi}},
  \code{\link{tfd_cholesky_lkj}},
  \code{\link{tfd_deterministic}},
  \code{\link{tfd_dirichlet_multinomial}},
  \code{\link{tfd_dirichlet}}, \code{\link{tfd_empirical}},
  \code{\link{tfd_exponential}},
  \code{\link{tfd_gamma_gamma}}, \code{\link{tfd_gamma}},
  \code{\link{tfd_gaussian_process_regression_model}},
  \code{\link{tfd_gaussian_process}},
  \code{\link{tfd_geometric}}, \code{\link{tfd_gumbel}},
  \code{\link{tfd_half_cauchy}},
  \code{\link{tfd_half_normal}},
  \code{\link{tfd_hidden_markov_model}},
  \code{\link{tfd_horseshoe}},
  \code{\link{tfd_independent}},
  \code{\link{tfd_inverse_gamma}},
  \code{\link{tfd_inverse_gaussian}},
  \code{\link{tfd_joint_distribution_named}},
  \code{\link{tfd_joint_distribution_sequential}},
  \code{\link{tfd_kumaraswamy}}, \code{\link{tfd_laplace}},
  \code{\link{tfd_linear_gaussian_state_space_model}},
  \code{\link{tfd_lkj}}, \code{\link{tfd_log_normal}},
  \code{\link{tfd_logistic}},
  \code{\link{tfd_mixture_same_family}},
  \code{\link{tfd_mixture}}, \code{\link{tfd_multinomial}},
  \code{\link{tfd_multivariate_normal_diag_plus_low_rank}},
  \code{\link{tfd_multivariate_normal_diag}},
  \code{\link{tfd_multivariate_normal_full_covariance}},
  \code{\link{tfd_multivariate_normal_linear_operator}},
  \code{\link{tfd_multivariate_normal_tri_l}},
  \code{\link{tfd_multivariate_student_t_linear_operator}},
  \code{\link{tfd_negative_binomial}},
  \code{\link{tfd_normal}},
  \code{\link{tfd_one_hot_categorical}},
  \code{\link{tfd_pareto}}, \code{\link{tfd_pixel_cnn}},
  \code{\link{tfd_poisson}},
  \code{\link{tfd_probit_bernoulli}},
  \code{\link{tfd_quantized}},
  \code{\link{tfd_relaxed_bernoulli}},
  \code{\link{tfd_relaxed_one_hot_categorical}},
  \code{\link{tfd_sample_distribution}},
  \code{\link{tfd_sinh_arcsinh}},
  \code{\link{tfd_student_t_process}},
  \code{\link{tfd_student_t}},
  \code{\link{tfd_transformed_distribution}},
  \code{\link{tfd_triangular}},
  \code{\link{tfd_truncated_normal}},
  \code{\link{tfd_uniform}},
  \code{\link{tfd_variational_gaussian_process}},
  \code{\link{tfd_vector_diffeomixture}},
  \code{\link{tfd_vector_exponential_diag}},
  \code{\link{tfd_vector_exponential_linear_operator}},
  \code{\link{tfd_vector_laplace_diag}},
  \code{\link{tfd_vector_laplace_linear_operator}},
  \code{\link{tfd_vector_sinh_arcsinh_diag}},
  \code{\link{tfd_von_mises_fisher}},
  \code{\link{tfd_von_mises}},
  \code{\link{tfd_wishart_linear_operator}},
  \code{\link{tfd_wishart_tri_l}},
  \code{\link{tfd_wishart}}, \code{\link{tfd_zipf}}
}
\concept{distributions}
