% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_features.R
\name{compare_features}
\alias{compare_features}
\title{Conduct statistical testing on time-series feature classification performance to identify top features or compare entire sets}
\usage{
compare_features(
  data,
  metric = c("accuracy", "precision", "recall", "f1"),
  by_set = TRUE,
  hypothesis = c("null", "pairwise"),
  p_adj = c("none", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr")
)
}
\arguments{
\item{data}{\code{list} object containing the classification outputs produce by \code{tsfeature_classifier}}

\item{metric}{\code{character} denoting the classification performance metric to use in statistical testing. Can be one of \code{"accuracy"}, \code{"precision"}, \code{"recall"}, \code{"f1"}. Defaults to \code{"accuracy"}}

\item{by_set}{\code{Boolean} specifying whether you want to compare feature sets (if \code{TRUE}) or individual features (if \code{FALSE}). Defaults to \code{TRUE} but this is contingent on whether you computed by set or not in \code{tsfeature_classifier}}

\item{hypothesis}{\code{character} denoting whether p-values should be calculated for each feature set or feature (depending on \code{by_set} argument) individually relative to the null if \code{use_null = TRUE} in \code{tsfeature_classifier} through \code{"null"}, or whether pairwise comparisons between each set or feature should be conducted on main model fits only through \code{"pairwise"}. Defaults to \code{"null"}}

\item{p_adj}{\code{character} denoting the adjustment made to p-values for multiple comparisons. Should be a valid argument to \code{stats::p.adjust}. Defaults to \code{"none"} for no adjustment. \code{"holm"} is recommended as a starting point for adjustments}
}
\value{
\code{data.frame} containing the results
}
\description{
Conduct statistical testing on time-series feature classification performance to identify top features or compare entire sets
}
\examples{
\donttest{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)
  
classifiers <- tsfeature_classifier(featMat,
  by_set = FALSE)
  
compare_features(classifiers,
  by_set = FALSE,
  hypothesis = "pairwise") 
}

}
\references{
Henderson, T., Bryant, A. G., and Fulcher, B. D. Never a Dull Moment: Distributional Properties as a Baseline for Time-Series Classification. 27th Pacific-Asia Conference on Knowledge Discovery and Data Mining, (2023).
}
\author{
Trent Henderson
}
