% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{igraph2graphjs}
\alias{igraph2graphjs}
\title{Convert \code{igraph} graph objects to a simpler form used by \code{\link{graphjs}}}
\usage{
igraph2graphjs(ig)
}
\arguments{
\item{ig}{A graph object from \code{igraph}}
}
\value{
A list with node and edges data frame entries used by \code{\link{graphjs}}.
}
\description{
Convert \code{igraph} graph objects to a simpler form used by \code{\link{graphjs}}
}
\examples{
\dontrun{
  library(igraph)
  g <- make_ring(10) \%>\%
       set_edge_attr("weight", value = 1:10) \%>\%
       set_edge_attr("color", value = "red") \%>\%
       set_vertex_attr("name", value = letters[1:10])
  (G <- igraph2graphjs(g))

  # Can also directly run:
  graphjs(g)
}
}

