# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generic function for calculating thermo- and kinematic indices derived from atmospheric profiling.
#' Further details given in the sounding_compute() function
#' 
#'
#' @param pressure pressure [hPa]
#' @param altitude altitude [meters]
#' @param temp temperature [degree Celsius]
#' @param dpt dew point temperature [degree Celsius]
#' @param wd wind direction [azimuth in degrees]
#' @param ws wind speed [knots]
#' @param export_profile possibility to export interpolated profile on the levels defined in accuracy configuration
#' @param accuracy accuracy of computations where 3 = high (slow), 2 = medium (recommended), 1 = low (fast)
#' @examples 
#' pressure = c(1000, 855, 700, 500, 300, 100, 10) 
#' altitude = c(0, 1500, 2500, 6000, 8500, 12000, 25000)
#' temp = c(25, 10, 0, -15, -30, -50, -92)
#' dpt = c(20, 5, -5, -30, -55, -80, -99)
#' wd = c(0, 90, 135, 180, 270, 350, 0)
#' ws = c(5, 10, 20, 30, 40, 5, 0)
#' sounding_default(pressure, altitude, temp, dpt, wd, ws, accuracy = 1, export_profile = 0)
#' @useDynLib thunder
#' @importFrom Rcpp evalCpp
#' @export
#' @return 
#' \enumerate{
#'  \item MU_CAPE
#'  \item MU_03km_CAPE
#'  \item MU_HGL_CAPE
#'  \item MU_CIN
#'  \item MU_LCL_HGT
#'  \item MU_LFC_HGT
#'  \item MU_EL_HGT
#'  \item MU_LI
#'  \item MU_WMAX
#'  \item MU_EL_TEMP
#'  \item MU_LCL_TEMP
#'  \item MU_LFC_TEMP
#'  \item MU_MIXR
#'  \item SB_CAPE
#'  \item SB_03km_CAPE
#'  \item SB_HGL_CAPE
#'  \item SB_CIN
#'  \item SB_LCL_HGT
#'  \item SB_LFC_HGT
#'  \item SB_EL_HGT
#'  \item SB_LI
#'  \item SB_WMAX
#'  \item SB_EL_TEMP
#'  \item SB_LCL_TEMP
#'  \item SB_LFC_TEMP
#'  \item SB_MIXR
#'  \item ML_CAPE
#'  \item ML_03km_CAPE
#'  \item ML_HGL_CAPE
#'  \item ML_CIN
#'  \item ML_LCL_HGT
#'  \item ML_LFC_HGT
#'  \item ML_EL_HGT
#'  \item ML_LI
#'  \item ML_WMAX
#'  \item ML_EL_TEMP
#'  \item ML_LCL_TEMP
#'  \item ML_LFC_TEMP
#'  \item ML_MIXR
#'  \item LR_01km
#'  \item LR_03km
#'  \item LR_24km
#'  \item LR_36km
#'  \item LR_500700hPa
#'  \item LR_500800hPa
#'  \item FRZG_HGT
#'  \item FRZG_wetbulb_HGT
#'  \item HGT_max_thetae_03km
#'  \item HGT_min_thetae_04km
#'  \item Delta_thetae
#'  \item Delta_thetae_HGL
#'  \item DCAPE
#'  \item Cold_Pool_Strength
#'  \item Wind_Index  
#'  \item PRCP_WATER
#'  \item Moisture_Flux_02km
#'  \item RH_02km
#'  \item RH_25km
#'  \item RH_HGL
#'  \item BS_01km
#'  \item BS_02km
#'  \item BS_03km
#'  \item BS_06km
#'  \item BS_08km
#'  \item BS_36km
#'  \item BS_18km
#'  \item BS_EFF_MU
#'  \item BS_EFF_SB
#'  \item BS_EFF_ML
#'  \item BS_SFC_to_HGL
#'  \item BS_MU_LFC_to_HGL
#'  \item BS_SB_LFC_to_HGL
#'  \item BS_ML_LFC_to_HGL
#'  \item MW_01km
#'  \item MW_02km
#'  \item MW_06km
#'  \item MW_13km
#'  \item SRH_100m_RM
#'  \item SRH_500m_RM
#'  \item SRH_1km_RM
#'  \item SRH_3km_RM
#'  \item SRH_100m_LM
#'  \item SRH_500m_LM
#'  \item SRH_1km_LM
#'  \item SRH_3km_LM
#'  \item Bunkers_RM_A
#'  \item Bunkers_RM_M
#'  \item Bunkers_LM_A
#'  \item Bunkers_LM_M
#'  \item Bunkers_MW_A
#'  \item Bunkers_MW_M
#'  \item K_Index
#'  \item Showalter_Index
#'  \item TotalTotals_Index
#'  \item SWEAT_Index
#'  \item STP
#'  \item STP_new
#'  \item SCP
#'  \item SCP_new
#'  \item SHIP
#'  \item DCP
#'  \item MU_WMAXSHEAR
#'  \item SB_WMAXSHEAR
#'  \item ML_WMAXSHEAR
#'  \item MU_EFF_WMAXSHEAR
#'  \item SB_EFF_WMAXSHEAR
#'  \item ML_EFF_WMAXSHEAR
#' }
sounding_default <- function(pressure, altitude, temp, dpt, wd, ws, export_profile, accuracy) {
    .Call('_thunder_sounding_default', PACKAGE = 'thunder', pressure, altitude, temp, dpt, wd, ws, export_profile, accuracy)
}

