#' Triplets of Pairwise Comparisons
#'
#' @description This data set contains synthetic data
#' of 200 participants on 4 triplets. In each triplet,
#' participants had to rank the three alternative items according
#' to their preference. Reponses were then converted into
#' a set of dichotomous pairwise responses between all the
#' three alternatives. More details can be found in
#' Brown and Maydeu-Olivares (2011).
#'
#' @format A data frame of 200 observations containing
#'   information on 12 variables.
#'   Overall, the 12 items measure 3 different traits.
#'   Items 1, 4, 7, and 10 load on trait 1,
#'   items 2, 5, 8, and 11 load on trait 2, and
#'   items 3, 6, 9, and 12 load on trait 3.
#'   Moreover, items 4, 9, and 11 are inverted.
#' \describe{
#'   \item{i1i2}{Response preferences between item 1 and 2.}
#'   \item{i1i3}{Response preferences between item 1 and 3.}
#'   \item{i2i3}{Response preferences between item 2 and 3.}
#'   \item{i4i5}{Response preferences between item 4 and 5.}
#'   \item{i4i6}{Response preferences between item 4 and 6.}
#'   \item{i5i6}{Response preferences between item 5 and 6.}
#'   \item{i7i8}{Response preferences between item 7 and 8.}
#'   \item{i7i9}{Response preferences between item 7 and 9.}
#'   \item{i8i9}{Response preferences between item 8 and 9.}
#'   \item{i10i11}{Response preferences between item 10 and 11.}
#'   \item{i10i12}{Response preferences between item 10 and 12.}
#'   \item{i11i12}{Response preferences between item 11 and 12.}
#' }
#'
#' @examples
#' # load the data
#' data("triplets")
#'
#' # define the blocks of items
#' blocks <-
#'   set_block(c("i1", "i2", "i3"), traits = c("t1", "t2", "t3"),
#'           signs = c(1, 1, 1)) +
#'   set_block(c("i4", "i5", "i6"), traits = c("t1", "t2", "t3"),
#'             signs = c(-1, 1, 1)) +
#'   set_block(c("i7", "i8", "i9"), traits = c("t1", "t2", "t3"),
#'             signs = c(1, 1, -1)) +
#'   set_block(c("i10", "i11", "i12"), traits = c("t1", "t2", "t3"),
#'             signs = c(1, -1, 1))
#'
#' # generate the data to be understood by 'thurstonianIRT'
#' tdat <- make_TIRT_data(
#'   triplets, blocks, direction = "larger",
#'   format = "pairwise", family = "bernoulli", range = c(0, 1)
#' )
#'
#' \donttest{
#' # fit the data using Stan
#' fit <- fit_TIRT_stan(tdat, chains = 1)
#' print(fit)
#' predict(fit)
#' }
#'
#' @source
#' Brown, A., & Maydeu-Olivares, A. (2011). Item response modeling of
#' forced-choice questionnaires. Educational and Psychological Measurement,
#' 71(3), 460-502. doi:10.1177/0013164410375112
"triplets"
