% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble-package.R
\docType{package}
\name{tibble-package}
\alias{tibble-package}
\title{tibble: Simple Data Frames}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Provides a 'tbl_df' class (the 'tibble') with stricter checking and better formatting than the traditional data frame.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The tibble package provides utilities for handling \strong{tibbles}, where
"tibble" is a colloquial term for the S3 \code{\link{tbl_df}} class. The \code{\link{tbl_df}}
class is a special case of the base \code{\link[base:data.frame]{data.frame}}.
class, developed in response to lessons learned over many years of data
analysis with data frames.

Tibble is the central data structure for the set of packages known as the
\href{https://www.tidyverse.org/packages/}{tidyverse}, including
\href{https://dplyr.tidyverse.org/}{dplyr},
\href{https://ggplot2.tidyverse.org/}{ggplot2},
\href{https://tidyr.tidyverse.org/}{tidyr}, and
\href{https://readr.tidyverse.org/}{readr}.

General resources:
\itemize{
\item Website for the tibble package: \url{https://tibble.tidyverse.org}
\item \href{https://r4ds.had.co.nz/tibbles.html}{Tibbles chapter} in \emph{R for Data
Science}
}

Resources on specific topics:
\itemize{
\item Create a tibble: \code{\link[=tibble]{tibble()}}, \code{\link[=as_tibble]{as_tibble()}}, \code{\link[=tribble]{tribble()}}, \code{\link[=enframe]{enframe()}}
\item Inspect a tibble: \code{\link[=print.tbl]{print.tbl()}}, \code{\link[=glimpse]{glimpse()}}
\item Details on the S3 \code{tbl_df} class: \code{\linkS4class{tbl_df}}
\item Package options: \link{tibble_options}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://tibble.tidyverse.org/}
  \item \url{https://github.com/tidyverse/tibble}
  \item Report bugs at \url{https://github.com/tidyverse/tibble/issues}
}

}
\author{
\strong{Maintainer}: Kirill Müller \email{krlmlr+r@mailbox.org}

Authors:
\itemize{
  \item Hadley Wickham \email{hadley@rstudio.com}
}

Other contributors:
\itemize{
  \item Romain Francois \email{romain@r-enthusiasts.com} [contributor]
  \item Jennifer Bryan \email{jenny@rstudio.com} [contributor]
  \item RStudio [copyright holder, funder]
}

}
