% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_funs.R
\name{set_variable_labels}
\alias{set_variable_labels}
\alias{set_variable_groups}
\alias{set_variable_abbrs}
\alias{set_variable_notes}
\alias{set_variable_units}
\title{Set variable attributes}
\usage{
set_variable_labels(data, ...)

set_variable_groups(data, ...)

set_variable_abbrs(data, ...)

set_variable_notes(data, ...)

set_variable_units(data, ...)
}
\arguments{
\item{data}{a data frame.}

\item{...}{name-value pairs of variable groups and names (see examples)}
}
\value{
a \link[tibble:tibble-package]{tibble}, adorned with additional
attributes based on user input.
}
\description{
These functions allow you to embed attributes in data
so that you only need to think about them once. Some functions
may overwrite or delete attributes in data, so it is recommended
that you create a \code{meta} data object with the \link{build_meta} function
after you have set variable labels, groups, notes, abbreviations,
and units.
}
\details{
\itemize{
\item \link{tibble_one} will handle attributes of data automatically,
e.g., replacing variable names with variable labels, and placing
variable acronyms (i.e., abbreviations) at the bottom of the
table in a footnote.
\item Use \code{set_variable_labels()} to set the values that will represent
variables in table one.
\item Use \code{set_variable_groups()} to change the
variables that are listed in the variable categories of table one.
\item Use \code{set_variable_notes} to add descriptions of variables that will
be placed at the bottom of table one as a footnote.
\item Use \code{set_variable_abbrs} to indicate what acronyms in variable
labels mean (see examples).
\item Use \code{set_variable_units} to indicate the unit of measurement for
continuous variables.
}

For \code{set_variable_labels}, names are variables and values are labels.
For example, writing \code{gfr_variable} = "estimated GFR" as an input to
\code{set_variable_labels} will set the label for \code{gfr_variable} as the
indicated string. Since GFR is an acronym, we would also want to use
\code{set_variable_abbrs()} and say gfr_variable = c("GFR" =
"glomerular filtration rate") (see examples).
}
\note{
The \code{set_variable_labels} function in \code{tibbleOne} is a wrapper
of the \link[labelled:var_label]{labelled} function,
developed by Joseph Larmarange.
}
\examples{

df <- data.frame(
  gfr = c(1,2,3),
  sbp = c(3,2,1)
)

df <- set_variable_labels(df,
  gfr = 'Estimated GFR',
  sbp = 'Systolic BP'
)

df <- set_variable_units(df,
  gfr = 'mL/min/1.73 m2',
  sbp = 'mm Hg'
)

df <- set_variable_abbrs(df,
  gfr = c("GFR" = "glomerular filtration rate", "min" = 'minute'),
  sbp = c("BP" = "blood pressure")
)

df <- set_variable_notes(df,
  sbp = "blood pressure was measured by trained personnel"
)

build_meta(df)

}
