% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round-index.R
\name{ceiling_index}
\alias{ceiling_index}
\title{A simple wrapper of \code{\link[lubridate:ceiling_date]{lubridate::ceiling_date()}}}
\usage{
ceiling_index(x, unit = "seconds")
}
\arguments{
\item{x}{a vector of date-time objects}

\item{unit}{a character string specifying a time unit or a multiple of a unit
to be rounded to. Valid base units are \code{second}, \code{minute}, \code{hour}, \code{day},
\code{week}, \code{month}, \code{bimonth}, \code{quarter}, \code{season}, \code{halfyear} and
\code{year}. Arbitrary unique English abbreviations as in the \code{\link[lubridate:period]{period()}}
constructor are allowed. Rounding to multiples of units (except weeks) is
supported.}
}
\description{
This is a thin wrapper around a \code{\link[lubridate:ceiling_date]{lubridate::ceiling_date()}} that works
for \code{hms}, \code{yearmon}, and \code{yearqtr} classes as well.
}
\examples{

data(FB)
dplyr::mutate(FB, date2 = ceiling_index(date, "year"))

time_test <- create_series('00:00:00'~'12:00:00',
                           '1 minute', class = "hms")

dplyr::mutate(time_test, date2 = ceiling_index(date, "hour"))

}
\seealso{
\code{\link[lubridate:ceiling_date]{lubridate::ceiling_date()}}
}
