% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-workflow-sets.R
\name{create_workflow_set}
\alias{create_workflow_set}
\title{Create a Workflow Set Object}
\usage{
create_workflow_set(.model_tbl = NULL, .recipe_list = list(), .cross = TRUE)
}
\arguments{
\item{.model_tbl}{The model table that is generated from a function like
\code{fast_regression_parsnip_spec_tbl()}. The model spec column will be grabbed
automatically as the class of the object must be \code{tidyaml_base_tbl}}

\item{.recipe_list}{Provide a list of recipes here that will get added to the
workflow set object.}

\item{.cross}{The default is TRUE, can be set to FALSE. This is passed to the
\code{cross} parameter as an argument to the \code{workflow_set()} function.}
}
\value{
A list object of workflows.
}
\description{
Create a workflow set object tibble from a model spec tibble.
}
\details{
Create a \verb{workflow set} object/tibble from a model spec tibble where
the object class type is \code{tidyaml_base_tbl}. This function will take in a list
of recipes and will grab the model specifications from the base tibble to
create the workflow sets object. You can also supply the logical of TRUE/FALSe
the \code{.cross} parameter which gets passed to the corresponding parameter as an
argumnt to the \code{\link[workflowsets:workflow_set]{workflowsets::workflow_set()}} function.
}
\examples{
library(recipes)

rec_obj <- recipe(mpg ~ ., data = mtcars)
spec_tbl <- fast_regression_parsnip_spec_tbl(
  .parsnip_fns = "linear_reg",
  .parsnip_eng = c("lm","glm")
)

create_workflow_set(
  spec_tbl,
  list(rec_obj)
)

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

Other Utility: 
\code{\link{core_packages}()},
\code{\link{create_splits}()},
\code{\link{fast_classification_parsnip_spec_tbl}()},
\code{\link{fast_regression_parsnip_spec_tbl}()},
\code{\link{full_internal_make_wflw}()},
\code{\link{install_deps}()},
\code{\link{load_deps}()},
\code{\link{match_args}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
