% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-wflw.R
\name{extract_wflw}
\alias{extract_wflw}
\title{Extract A Model Workflow}
\usage{
extract_wflw(.data, .model_id = NULL)
}
\arguments{
\item{.data}{The model table that must have the class \code{tidyaml_mod_spec_tbl}.}

\item{.model_id}{The model number that you want to select, Must be an integer
or sequence of integers, ie. \code{1} or \code{c(1,3,5)} or \code{1:2}}
}
\value{
A tibble with the chosen model workflow(s).
}
\description{
Extract a model workflow from a tidyAML model tibble.
}
\details{
This function allows you to get a model workflow or more from
a tibble with a class of "tidyaml_mod_spec_tbl". It allows you to select the
model by the \code{.model_id} column. You can call the model id's by an integer
or a sequence of integers.
}
\examples{
library(recipes)

rec_obj <- recipe(mpg ~ ., data = mtcars)
frt_tbl <- fast_regression(mtcars, rec_obj, .parsnip_eng = c("lm","glm"),
                                           .parsnip_fns = "linear_reg")

extract_wflw(frt_tbl, 1)
extract_wflw(frt_tbl, 1:2)

}
\seealso{
Other Extractor: 
\code{\link{extract_model_spec}()},
\code{\link{extract_regression_residuals}()},
\code{\link{extract_wflw_fit}()},
\code{\link{extract_wflw_pred}()},
\code{\link{get_model}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Extractor}
