% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_extractor}
\alias{bf_extractor}
\title{Extract Bayes Factors from \code{BayesFactor} model object.}
\usage{
bf_extractor(bf.object, ...)
}
\arguments{
\item{bf.object}{An object from \code{BayesFactor} package.}

\item{...}{Additional arguments passed to
\code{\link[parameters:model_parameters.BFBayesFactor]{parameters::model_parameters.BFBayesFactor()}}.}
}
\description{
Extract Bayes Factors from \code{BayesFactor} model object.
}
\note{
\emph{Important}: don't enter \code{1/bf_obj} to extract results for null
hypothesis; doing so will return wrong results.
}
\examples{
set.seed(123)

# creating a `BayesFactor` object
bf_obj <-
  BayesFactor::anovaBF(
    formula = Sepal.Length ~ Species,
    data = iris,
    progress = FALSE
  )

# extracting Bayes Factors in a dataframe
bf_extractor(bf_obj)
}
