% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_tableGen_utils.R
\name{data_to_filter}
\alias{data_to_filter}
\title{The smallest possible data set we could filter to semi-join later}
\usage{
data_to_filter(datafile, input_filter_df)
}
\arguments{
\item{datafile}{list of ADaM-ish dataframes}

\item{input_filter_df}{The name of a dataset stored in `datafile`}
}
\value{
A `data.frame` object based on the reduction of `datafile` from `input_filter_df`.
}
\description{
The smallest possible data set we could filter to semi-join later
}
\examples{
datalist <- list(ADSL = tidyCDISC::adsl, ADAE = tidyCDISC::adae, 
                 ADVS = tidyCDISC::advs, ADLBC = tidyCDISC::adlbc, 
                 ADTTE = tidyCDISC::adtte)

# Returns combined dataset
data_to_filter(datalist, c("ADSL", "ADAE"))
}
\keyword{tabGen_repro}
