% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{annotation_numeric}
\alias{annotation_numeric}
\alias{annotation_numeric,InputHeatmap-method}
\title{Adds a numeric annotation layer to an `InputHeatmap`, that on evaluation creates a `ComplexHeatmap`}
\source{
[Mangiola and Papenfuss, 2020](https://joss.theoj.org/papers/10.21105/joss.02472)
}
\usage{
annotation_numeric(
  .data,
  .column,
  palette = NULL,
  size = NULL,
  labels_format = function(x) sprintf("\%.1f", x),
  ...
)

\S4method{annotation_numeric}{InputHeatmap}(
  .data,
  .column,
  palette = NULL,
  size = NULL,
  labels_format = function(x) sprintf("\%.1f", x),
  ...
)
}
\arguments{
\item{.data}{A `tbl_df` formatted as | <ELEMENT> | <FEATURE> | <VALUE> | <...> |}

\item{.column}{Vector of quotes}

\item{palette}{A character vector of colours, or a function such as colorRamp2 (see examples).}

\item{size}{A grid::unit object, e.g. unit(2, "cm"). This is the height or width of the annotation depending on the orientation.}

\item{labels_format}{A function to format the numeric labels. By default, 
it formats numbers to two decimal places using `sprintf("%.2f", x)`. You can
supply any function that takes a numeric vector and returns a character vector
for customised formatting.}

\item{...}{The arguments that will be passed to 
\code{\link[ComplexHeatmap:anno_numeric]{anno_numeric}} and 
\code{\link[ComplexHeatmap:HeatmapAnnotation]{HeatmapAnnotation}}
if you want to fine tune the aesthetics.}
}
\value{
An `InputHeatmap` object that gets evaluated to a `ComplexHeatmap`.

An `InputHeatmap` object that gets evaluated to a `ComplexHeatmap`.
}
\description{
`annotation_numeric()` from an `InputHeatmap` object adds a numeric annotation layer.
}
\details{
\lifecycle{maturing}

It uses `ComplexHeatmap` as the visualisation tool.
}
\examples{

hm = 
  tidyHeatmap::N52 |>
  tidyHeatmap::heatmap(
    .row = symbol_ct,
    .column = UBR,
    .value = `read count normalised log`
)

hm |> annotation_numeric(inflection)

# Align to the right 
hm |> annotation_numeric(inflection, align_to = "right")

}
\references{
Mangiola, S. and Papenfuss, A.T., 2020. "tidyHeatmap: an R package for 
  modular heatmap production based on tidy principles." Journal of Open Source Software.
  doi:10.21105/joss.02472.
}
