% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-profiles.R
\name{get_fit}
\alias{get_fit}
\alias{get_fit.tidyLPA}
\alias{get_fit.tidyProfile}
\title{Get fit indices from objects generated by tidyLPA}
\usage{
get_fit(x, ...)

\method{get_fit}{tidyLPA}(x, ...)

\method{get_fit}{tidyProfile}(x, ...)
}
\arguments{
\item{x}{An object generated by tidyLPA.}

\item{...}{further arguments to be passed to or from other methods. They are
ignored in this function.}
}
\value{
A tibble. Learn more at https://data-edu.github.io/tidyLPA/articles/Introduction_to_tidyLPA.html#getting-fit-statistics
}
\description{
Get fit indices from objects generated by tidyLPA.
}
\section{Methods (by class)}{
\itemize{
\item \code{tidyLPA}: Get fit indices for a latent profile analysis with
multiple numbers of classes and models, of class 'tidyLPA'.

\item \code{tidyProfile}: Get fit indices for a single latent profile analysis
object, of class 'tidyProfile'.
}}

\examples{
\dontrun{
if(interactive()){
 results <- iris \%>\%
   select(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width) \%>\%
   estimate_profiles(3)
 get_fit(results)
 get_fit(results[[1]])
 }
}
}
\author{
Caspar J. van Lissa
}
