% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_funs.R
\name{otu_filter}
\alias{otu_filter}
\title{A function to aggregate low prevalence, abundance, or unwanted taxa together}
\usage{
otu_filter(
  micro_set,
  prev_cutoff = 0,
  ra_cutoff = 0,
  exclude_taxa = NULL,
  filter_summary = T
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{prev_cutoff}{Minimum percent of subjects with OTU counts above 0}

\item{ra_cutoff}{At leat one subject must have RA above this subject}

\item{exclude_taxa}{A character vector of OTU names that you would like filter into your "Other" category}

\item{filter_summary}{Logical; print out summaries of filtering steps}
}
\value{
Returns a tidy_micro set
}
\description{
Will take a tidi_micro set and aggregate the raw counts of taxa with a low prevalence and/or abundance into a new "Other" taxa. Can also find specific taxa you'd like to include in the "Other" taxa counts. Once the counts are aggregated taxa relative abundance, centered log ratio (CLR) transformations, and presence will be recalculated. This recalculation will only change the "Other" category
}
\details{
\eqn{\frac{1}{Total}}{1/Total} will be added to each taxa count for CLR tranformations in order to avoid issues with log(0)
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)

otu_tabs <- list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

filter_set <- set \%>\%
otu_filter(prev_cutoff = 5, ## 5\% of subjects must have this bug, or it is filtered
  ra_cutoff = 1, ## At least 1 subject must have RA of 1, or it is filtered
  exclude_taxa = c("Unclassified", "Bacteria") ## Unclassified taxa we don't want
)
}
\author{
Charlie Carpenter and Dan Frank
}
