% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax-add_paths.R
\name{add_paths}
\alias{add_paths}
\title{Add paths to an object of class 'tidy_sem'}
\usage{
add_paths(model, ...)
}
\arguments{
\item{model}{An object of class \code{tidy_sem}.}

\item{...}{Paths to add or substitute, specified in
\code{\link{lavaan}{model.syntax}}, and separated by commas.}
}
\value{
An object of class \code{tidy_sem}.
}
\description{
Add paths to an object of class \code{tidy_sem}, or replace
existing paths. The paths must be specified as
\code{\link[lavaan]{model.syntax}}, and separated by commas.
}
\details{
Currently, only the \code{\link{lavaan}{lavaan}} commands \code{~,
~~, =~,} and \code{~1} are parsed.

This function
relies on \code{lavaan \link[lavaan]{model.syntax}} to convert syntax strings
to \code{lavaan} parameter tables. By default, is uses the arguments
\code{int.ov.free = TRUE, int.lv.free = FALSE, auto.fix.first = TRUE,
auto.fix.single = TRUE, auto.var = TRUE, auto.cov.lv.x = TRUE,
auto.efa = TRUE, auto.th = TRUE, auto.delta = TRUE, auto.cov.y = TRUE}, akin
to \code{\link[lavaan]{sem}} and \code{\link[lavaan]{cfa}}.
}
\examples{
library(lavaan)
df <- iris[, 1:4]
names(df) <- paste0("x_", 1:4)
model <- tidy_sem(df)
model <- measurement(model)
model <- add_paths(model, x =~ a*x_1 + b*x_2 + a*x_3 + b*x_4)
res <- estimate_lavaan(model)
summary(res)
}
\seealso{
\code{\link[lavaan]{model.syntax}}
}
