% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_mixture.R
\name{mixture_starts}
\alias{mixture_starts}
\title{Automatically set starting values for an OpenMx mixture model}
\usage{
mixture_starts(model, splits, ...)
}
\arguments{
\item{model}{A mixture model of class \code{mxModel}.}

\item{splits}{Optional. A numeric vector of length equal to the number of
rows in the \code{\link{mxData}} used in the \code{model} object. The data
will be split by this vector. See Details for the default setting and
possible alternatives.}

\item{...}{Additional arguments, passed to functions.}
}
\value{
Returns an \code{\link[OpenMx]{mxModel}} with starting values.
}
\description{
Automatically set starting values for an OpenMx mixture model. This function
was designed to work with mixture models created using \code{tidySEM}
functions like \code{\link{mx_mixture}}, and may not work with other
\code{mxModel}s.
}
\details{
Starting values are derived by the following procedure:
\enumerate{
  \item The mixture model is converted to a multi-group model.
  \item The data are split along \code{splits}, and assigned to the
  corresponding groups of the multi-group model.
  \item The multi-group model is run, and the final values of each group are
  assigned to the corresponding mixture component as starting values.
  \item The mixture model is returned with these starting values.
}

If the argument \code{splits} is not provided, the function will call
\code{\link[stats]{kmeans}}\code{(x = data, centers = classes)$cluster},
where \code{data} is extracted from the \code{model} argument.

Sensible ways to split the data include:
\itemize{
  \item Using Hierarchical clustering:
   \code{cutree(hclust(dist(data)), k = classes))}
  \item Using K-means clustering:
  \code{\link[stats]{kmeans}}\code{(x = data, centers = classes)$cluster}
  \item Using agglomerative hierarchical clustering:
  \code{hclass(}\code{\link[mclust]{hc}}\code{(data = data), G = classes)[, 1]}
  \item Using a random split:
  \code{\link{sample.int}}\code{(n = classes,
  size = nrow(data), replace = TRUE)}
}
}
\examples{
\dontrun{
df <- iris[, 1, drop = FALSE]
names(df) <- "x"
mod <- mx_mixture(model = "x ~ m{C}*1
                           x ~~ v{C}*x",
                           classes = 2,
                           data = df,
                           run = FALSE)
mod <- mixture_starts(mod)
}
}
\references{
Shireman, E., Steinley, D. & Brusco, M.J. Examining the effect of
initialization strategies on the performance of Gaussian mixture modeling.
Behav Res 49, 282–293 (2017). <doi:10.3758/s13428-015-0697-6>
}
\keyword{mixture}
\keyword{models}
\keyword{openmx}
