% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_interval.R, R/stat_intervalh.R
\name{stat_interval}
\alias{stat_interval}
\alias{stat_intervalh}
\title{Multiple probability interval plots (ggplot stat)}
\usage{
stat_interval(mapping = NULL, data = NULL, geom = "interval",
  position = "identity", ..., point_interval = median_qi,
  fun.data = NULL, .width = c(0.5, 0.8, 0.95), .prob,
  fun.args = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

stat_intervalh(mapping = NULL, data = NULL, geom = "intervalh",
  position = "identity", ..., point_interval = median_qi,
  fun.data = NULL, .width = c(0.5, 0.8, 0.95), .prob,
  fun.args = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set at the
layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{Use to override the default connection between
\code{geom_interval}/\code{geom_interval} and \code{stat_interval}/\code{stat_intervalh}.}

\item{position}{The position adjustment to use for overlapping points on this layer.}

\item{...}{Other arguments passed to \code{\link{layer}}. They may also be arguments to the paired geom.}

\item{point_interval}{A function that when given a vector should
return a data frame with variables \code{y}, \code{ymin}, \code{ymax}, and \code{.width}; or
\code{x}, \code{xmin}, \code{xmax}, and \code{.width}. \strong{Either is acceptable}: output
will be converted into the \code{y}-based aesthetics for \code{stat_interval} and the
\code{x}-based aesthetics for \code{stat_intervalh}. See the \code{point_interval} family of functions.}

\item{fun.data}{Similar to \code{point_interval}, for compatibility with \code{stat_summary}.
Note: if the summary function is passed using \code{fun.data}, the \code{x} and \code{y}-based aesthetics
are not converted to the correct form automatically.}

\item{.width}{The \code{.width} argument passed to \code{point_interval}.}

\item{.prob}{Deprecated. Use \code{.width} instead.}

\item{fun.args}{Other optional arguments passed to \code{fun.data}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? \code{NA}, the default, includes if any aesthetics
are mapped. \code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining with them. This is
most useful for helper functions that define both data and aesthetics and shouldn't inherit behavior from the
default plot specification, e.g. borders.}
}
\description{
A combination of \code{\link{stat_summary}} / \code{\link{stat_summaryh}} and
\code{\link{geom_interval}} / \code{\link{geom_intervalh}} with sensible defaults.
While the corresponding \code{geom}s are intended for use on
data frames that have already been summarized using a \code{\link{point_interval}}
function, these \code{stat}s are intended for use directly on data frames of draws, and
will perform the summarization using a \code{\link{point_interval}} function.
}
\examples{

library(magrittr)
library(ggplot2)

data(RankCorr, package = "tidybayes")

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  ggplot(aes(y = i, x = u_tau)) +
  stat_intervalh() +
  scale_color_brewer()

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  ggplot(aes(x = i, y = u_tau)) +
  stat_interval() +
  scale_color_brewer()

}
\seealso{
See \code{\link{geom_interval}} / \code{\link{geom_intervalh}} for the geom versions, intended for use on
intervals that have already been summarized using a \code{\link{point_interval}} function.
See \code{\link{stat_pointinterval}} / \code{\link{stat_pointintervalh}} for a similar stat intended for
point summaries and intervals.
}
