% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\docType{data}
\name{tidybayes-deprecated}
\alias{tidybayes-deprecated}
\alias{ggeye}
\alias{fitted_samples}
\alias{add_fitted_samples}
\alias{predicted_samples}
\alias{add_predicted_samples}
\alias{gather_samples}
\alias{gather_lsmeans_samples}
\alias{gather_emmeans_samples}
\alias{gather_terms}
\alias{extract_samples}
\alias{tidy_samples}
\alias{spread_samples}
\alias{as_sample_tibble}
\alias{as_sample_data_frame}
\alias{ungather_samples}
\alias{unspread_samples}
\alias{parameters}
\alias{geom_eye}
\alias{geom_eyeh}
\alias{geom_halfeyeh}
\alias{geom_slabh}
\alias{geom_intervalh}
\alias{GeomIntervalh}
\alias{geom_pointintervalh}
\alias{GeomPointintervalh}
\alias{geom_dotsh}
\alias{geom_dotsintervalh}
\alias{stat_dist_eyeh}
\alias{stat_dist_halfeyeh}
\alias{stat_dist_slabh}
\alias{stat_dist_intervalh}
\alias{stat_dist_pointintervalh}
\alias{stat_dist_gradientintervalh}
\alias{stat_dist_cdfintervalh}
\alias{stat_dist_ccdfintervalh}
\alias{stat_dist_dotsh}
\alias{stat_dist_dotsintervalh}
\alias{stat_eyeh}
\alias{stat_halfeyeh}
\alias{stat_slabh}
\alias{stat_intervalh}
\alias{stat_pointintervalh}
\alias{stat_gradientintervalh}
\alias{stat_cdfintervalh}
\alias{stat_ccdfintervalh}
\alias{stat_dotsh}
\alias{stat_dotsintervalh}
\alias{stat_histintervalh}
\alias{point_intervalh}
\alias{mean_qih}
\alias{median_qih}
\alias{mode_qih}
\alias{mean_hdih}
\alias{median_hdih}
\alias{mode_hdih}
\alias{mean_hdcih}
\alias{median_hdcih}
\alias{mode_hdcih}
\title{Deprecated functions, arguments, and column names in tidybayes}
\description{
Deprecated functions, arguments, and column names and their alternatives are listed below.
Many of the deprecations are due to a naming scheme overhaul in tidybayes version 1.0
(see \emph{Deprecated Functions} and \emph{Deprecated Arguments and Column Names} below) or due to
the deprecation of horizontal shortcut geoms and stats in tidybayes 2.1 (see
\emph{Deprecated Horizontal Shortcut Geoms and Stats}).
}
\section{Deprecated Functions}{


Several deprecated versions of functions use slightly different output
formats (e.g., they use names like \code{term} and \code{estimate} where new
functions use \code{.variable} and \code{.value}; or they set \code{.iteration} even
when iteration information is not available --- new functions always set \code{.draw}
but may not set \code{.iteration}), so be careful when upgrading to new function names.
See \emph{Deprecated Arguments and Column Names}, below, for more information.

Deprecated functions include:

\itemize{

\item \code{spread_samples}, \code{extract_samples}, and \code{tidy_samples} are
deprecated names for \code{\link[=spread_draws]{spread_draws()}}. The spread/gather terminology
better distinguishes the resulting data frame format, and \emph{draws} is more
correct terminology than \emph{samples} for describing multiple realizations from
a posterior distribution.

\item \code{gather_samples} is a deprecated name for \code{\link[=gather_draws]{gather_draws()}},
reflecting a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{unspread_samples} is a deprecated name for \code{\link[=unspread_draws]{unspread_draws()}},
reflecting a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{ungather_samples} is a deprecated name for \code{\link[=ungather_draws]{ungather_draws()}},
reflecting a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{fitted_samples} / \code{add_fitted_samples} are deprecated names for
\code{\link[=fitted_draws]{fitted_draws()}} / \code{\link[=add_fitted_draws]{add_fitted_draws()}},
reflecting a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{predicted_samples} / \code{add_predicted_samples} are deprecated names for
\code{\link[=predicted_draws]{predicted_draws()}} / \code{\link[=add_predicted_draws]{add_predicted_draws()}},
reflecting a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{gather_lsmeans_samples} and \code{gather_emmeans_samples} are deprecated aliases
for \code{\link[=gather_emmeans_draws]{gather_emmeans_draws()}}. The new name (estimated marginal means) is more
appropriate for Bayesian models than the old name (least-squares means), and reflects the
naming of the newer \code{emmeans} package. It also reflects
a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{as_sample_tibble} and \code{as_sample_data_frame} are deprecated aliases
for \code{\link[=tidy_draws]{tidy_draws()}}. The original intent of \code{as_sample_tibble} was to be
used primarily internally (hence its less user-friendly name); however, increasingly
I have come across use cases of \code{tidy_draws} that warrant a more user-friendly name.
It also reflects a package-wide move to using \emph{draws} instead of \emph{samples} for
describing multiple realizations from a distribution.

\item \code{ggeye} is deprecated: for a package whose goal is flexible and customizable
visualization, monolithic functions are inflexible and do not sufficiently capitalize on users'
existing knowledge of ggplot; instead, I think it is more flexible to design geoms and stats
that can used within a complete ggplot workflow. \code{\link[=stat_eye]{stat_eye()}} offers a horizontal
eye plot geom that can be used instead of \code{ggeye}.

\item See the sections below for additional deprecated functions, including
horizontal geoms, stats, and point_intervals

}
}

\section{Deprecated Eye Geom Spellings}{


\code{geom_eye}, \code{geom_eyeh}, and \code{geom_halfeyeh} are deprecated spellings of \code{\link[=stat_eye]{stat_eye()}} and
\code{\link[=stat_halfeye]{stat_halfeye()}} from before name standardization of stats and geoms. Use those functions instead.
}

\section{Deprecated Horizontal Shortcut Geoms and Stats}{


Due to the introduction of automatic orientation detection in tidybayes 2.1,
shortcut geoms and stats (which end in \code{h}) are no longer necessary, and are
deprecated. In most cases, these can simply be replaced with the same
geom without the \code{h} suffix and they will remain horizontal; e.g.
\code{stat_halfeyeh(...)} can simply be replaced with \code{stat_halfeye(...)}.
If automatic orientation detection fails, override it with the \code{orientation}
parameter; e.g. \code{stat_halfeye(orientation = "horizontal")}.

These deprecated stats and geoms include:
\itemize{
\item \code{stat_eyeh} / \code{stat_dist_eyeh}
\item \code{stat_halfeyeh} / \code{stat_dist_halfeyeh}
\item \code{geom_slabh} / \code{stat_slabh} / \code{stat_dist_slabh}
\item \code{geom_intervalh} / \code{stat_intervalh} / \code{stat_dist_intervalh}
\item \code{geom_pointintervalh} / \code{stat_pointintervalh} / \code{stat_dist_pointintervalh}
\item \code{stat_gradientintervalh} / \code{stat_dist_gradientintervalh}
\item \code{stat_cdfintervalh} / \code{stat_dist_cdfintervalh}
\item \code{stat_ccdfintervalh} / \code{stat_dist_ccdfintervalh}
\item \code{geom_dotsh} / \code{stat_dotsh} / \code{stat_dist_dotsh}
\item \code{geom_dotsintervalh} / \code{stat_intervalh} / \code{stat_dist_intervalh}
\item \code{stat_histintervalh}
}
}

\section{Deprecated Horizontal Point/Interval Functions}{


These functions ending in \code{h} (e.g., \code{point_intervalh}, \code{median_qih})
used to be needed for use with \code{ggstance::stat_summaryh}, but are
no longer necessary because \code{ggplot2::stat_summary()} supports
automatic orientation detection, so they have been deprecated.
They behave identically to the corresponding function without the \code{h},
except that when passed a vector, they return a data frame with
\code{x}/\code{xmin}/\code{xmax} instead of \code{y}/\code{ymin}/\code{ymax}.
\itemize{
\item \code{point_intervalh}
\item \code{mean_qih} / \code{median_qih} / \code{mode_qih}
\item \code{mean_hdih} / \code{median_hdih} / \code{mode_hdih}
\item \code{mean_hdcih} / \code{median_hdcih} / \code{mode_hdcih}
}
}

\section{Deprecated Arguments and Column Names}{


Versions of tidybayes before version 1.0 used a different naming scheme for several
arguments and output columns.

Deprecated arguments and column names are:

\itemize{
\item \code{term} is now \code{.variable}
\item \code{estimate} is now \code{.value}
\item \code{pred} is now \code{.prediction}
\item \code{conf.low} is now \code{.lower}
\item \code{conf.high} is now \code{.upper}
\item \code{.prob} is now \code{.width}
\item The \code{.draw} column was added, and should be used instead of \code{.chain}
and \code{.iteration} to uniquely identify draws when you do not care about chains. (\code{.chain} and
\code{.iteration} are still provided for identifying draws \emph{within} chains, if desired).
}

To translate to/from the old naming scheme in output, use \code{\link[=to_broom_names]{to_broom_names()}}
and \code{\link[=from_broom_names]{from_broom_names()}}.

Many of these names were updated in version 1.0 in order to
make terminology more consistent and in order to satisfy these criteria:

\itemize{
\item Ignore compatibility with broom names on the assumption an adapter function can be created.
\item Use names that could be compatible with frequentist approaches (hence \code{.width} instead of \code{.prob}).
\item Always precede with "." to avoid collisions with variable names in models.
\item No abbreviations (remembering if something is abbreviated or not can be a pain).
\item No two-word names (multi-word names can always be standardized on and used in documentation, but I think data frame output should be succinct).
\item Names should be nouns (I made an exception for lower/upper because they are common).
}
}

\author{
Matthew Kay
}
\keyword{datasets}
