% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_clusters.R
\name{add_clusters}
\alias{add_clusters}
\title{add_clusters}
\usage{
add_clusters(.data, ..., n_clusters = 4, cluster_name = "cluster")
}
\arguments{
\item{.data}{dataframe}

\item{...}{columns to cluster (tidyselect)}

\item{n_clusters}{integer}

\item{cluster_name}{column name}
}
\value{
data frame
}
\description{
Wraps \code{\link[ClusterR]{KMeans_rcpp}} to create a column that is a cluster formed from select columns in the data frame.
Clusters names are specified by capital letters.
}
\examples{

iris \%>\%
tibble::as_tibble() \%>\%
add_clusters(Sepal.Width, Sepal.Length, n_clusters = 3, cluster_name = "Sepal_Cluster") -> iris1

iris1

iris1 \%>\%
numeric_summary(original_col = Sepal.Width, bucket_col = Sepal_Cluster)
}
