% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuminc.R
\name{cuminc}
\alias{cuminc}
\alias{cuminc.formula}
\alias{cuminc.default}
\title{Competing Risks Cumulative Incidence}
\usage{
\method{cuminc}{formula}(formula, data, strata, rho = 0, ...)

cuminc(x, ...)

\method{cuminc}{default}(x, ...)
}
\arguments{
\item{formula}{formula with \code{Surv()} on LHS and covariates on RHS.
The event status variable must be a factor, with the first level indicating
'censor' and subsequent levels the competing risks.}

\item{data}{data frame}

\item{strata}{
stratification variable.  Has no effect on estimates.  Tests will be
stratified on this variable.  (all data in 1 stratum, if missing)
}

\item{rho}{
Power of the weight function used in the tests.
}

\item{...}{passed to methods}

\item{x}{input object}
}
\value{
tidycuminc object
}
\description{
Competing Risks Cumulative Incidence
}
\examples{
# calculate risk for entire cohort -----------
cuminc(Surv(ttdeath, death_cr) ~ 1, trial)

# calculate risk by treatment group ----------
cuminc(Surv(ttdeath, death_cr) ~ trt, trial)
}
\seealso{
Other cuminc() functions: 
\code{\link{autoplot.tidycuminc}()},
\code{\link{broom_methods_cuminc}}
}
\concept{cuminc() functions}
