% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{compute_t_test}
\alias{compute_t_test}
\title{Compute t-test}
\usage{
compute_t_test(test_var, data, group_var, levels, var.equal, paired,
  pooled_sd)
}
\arguments{
\item{test_var}{Test variable}

\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{group_var}{group variable (column name)}

\item{levels}{optional: a vector of length two specifying the two levels of
the group variable.}

\item{var.equal}{a logical variable indicating whether to treat the two
variances as being equal. If \code{TRUE} then the pooled variance is used to
estimate the variance otherwise the Welch (or Satterthwaite) approximation
to the degrees of freedom is used. Defaults to \code{TRUE}.}

\item{paired}{a logical indicating whether you want a paired t-test. Defaults
to \code{FALSE}.}

\item{pooled_sd}{a logical indicating whether to use the pooled standard
deviation in the calculation of Cohen's d. Defaults to \code{TRUE}.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Computes and outputs a t-test for one test variable
}
\seealso{
Other t-test: \code{\link{cohens_d}}, \code{\link{t_test}}
}
\concept{t-test}
