% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_fred.R
\name{download_data_fred}
\alias{download_data_fred}
\title{Download and Process Data from FRED}
\usage{
download_data_fred(series, start_date = NULL, end_date = NULL)
}
\arguments{
\item{series}{A character vector specifying the FRED series ID to download.}

\item{start_date}{The start date for filtering the data, in "YYYY-MM-DD" format.}

\item{end_date}{The end date for filtering the data, in "YYYY-MM-DD" format.}
}
\value{
A tibble containing the processed data with three columns:
\describe{
\item{date}{The date corresponding to the data point.}
\item{value}{The value of the data series at that date.}
\item{series}{The FRED series ID corresponding to the data.}
}
}
\description{
This function downloads a specified data series from the Federal Reserve Economic Data (FRED)
website, processes the data, and returns it as a tibble.
}
\details{
This function constructs the URL based on the provided FRED series ID, performs an HTTP GET
request to download the data in CSV format, and processes it to a tidy tibble format. The
resulting tibble includes the date, value, and the series ID.

This approach is inspired by \code{quantmod::getSymbolsFRED()} which uses a different wrapper around
the same FRED download data site. If you want to systematically download FRED data via API,
please consider using \code{fredr} package.
}
\examples{
\donttest{
  download_data_fred("CPIAUCNS")
  download_data_fred(c("GDP", "CPIAUCNS"), "2010-01-01", "2010-12-31")
}

}
