% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.hfr.R
\name{.model.hfr}
\alias{.model.hfr}
\title{Hierarchical feature regression for \code{tidyfit}}
\usage{
\method{.model}{hfr}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a hierarchical feature regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}
\itemize{
\item kappa_grid (\emph{proportional size of regression graph})
}

\strong{Important method arguments (passed to \code{\link{m}})}

The hierarchical feature regression is estimated using the \code{hfr::cv.hfr} function. See \code{?cv.hfr} for more details.

\strong{Implementation}

Features are standardized by default with coefficients transformed to the original scale.

If no hyperparameter grid is provided (\code{is.null(control$kappa_grid)}), the default is \code{seq(0, 1, by = 0.1)}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("hfr", Return ~ ., data, kappa_grid = 0.5)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("hfr", kappa_grid = c(0.1, 0.5)),
               .mask = c("Date", "Industry"))
coef(fit)

}
\references{
Pfitzinger J (2022).
\emph{hfr: Estimate Hierarchical Feature Regression Models}.
R package version 0.5.0, \url{https://CRAN.R-project.org/package=hfr}.
}
\seealso{
\code{\link{.model.plsr}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
