% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_dt.R
\name{nest_by}
\alias{nest_by}
\alias{unnest_col}
\title{Nest and unnest}
\usage{
nest_by(data, group = NULL, negate = FALSE)

unnest_col(data, col)
}
\arguments{
\item{data}{data.table, nested or unnested}

\item{group}{The variable for nest group, could recieve character vector or
regular expression.}

\item{negate}{Applicable when the "group" parameter uses regular expression,
if \code{TRUE}, return non-matching elements.}

\item{col}{The single variable of nested data to be unnested}
}
\value{
data.table, nested or unnested
}
\description{
Analogous function for \code{nest} and \code{unnest} in \pkg{tidyr}.
\code{unnest_col} will automatically remove other list-columns except for the
target list-column (which would be unnested later).
}
\details{
In the \code{nest_dt}, the data would be nested to a column named `ndt`,
 which is short for nested data.table.
}
\examples{

mtcars \%>\% nest_by("cyl")
mtcars \%>\% nest_by("cyl|vs")
mtcars \%>\% nest_by(c("cyl","vs"))

mtcars \%>\% nest_by("cyl|vs") \%>\%
  unnest_col(ndt)
}
\references{
https://www.r-bloggers.com/much-faster-unnesting-with-data-table/

https://stackoverflow.com/questions/25430986/create-nested-data-tables-by-collapsing-rows-into-new-data-tables
}
\seealso{
\code{\link[tidyr]{nest}}
}
